/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TextArrayOptions
implements ToCopyableBuilder<Builder, TextArrayOptions> {
    private final String defaultValue;
    private final String sourceFields;
    private final Boolean returnEnabled;
    private final Boolean highlightEnabled;
    private final String analysisScheme;

    private TextArrayOptions(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.sourceFields = builder.sourceFields;
        this.returnEnabled = builder.returnEnabled;
        this.highlightEnabled = builder.highlightEnabled;
        this.analysisScheme = builder.analysisScheme;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public String sourceFields() {
        return this.sourceFields;
    }

    public Boolean returnEnabled() {
        return this.returnEnabled;
    }

    public Boolean highlightEnabled() {
        return this.highlightEnabled;
    }

    public String analysisScheme() {
        return this.analysisScheme;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.defaultValue() == null ? 0 : this.defaultValue().hashCode());
        hashCode = 31 * hashCode + (this.sourceFields() == null ? 0 : this.sourceFields().hashCode());
        hashCode = 31 * hashCode + (this.returnEnabled() == null ? 0 : this.returnEnabled().hashCode());
        hashCode = 31 * hashCode + (this.highlightEnabled() == null ? 0 : this.highlightEnabled().hashCode());
        hashCode = 31 * hashCode + (this.analysisScheme() == null ? 0 : this.analysisScheme().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextArrayOptions)) {
            return false;
        }
        TextArrayOptions other = (TextArrayOptions)obj;
        if (other.defaultValue() == null ^ this.defaultValue() == null) {
            return false;
        }
        if (other.defaultValue() != null && !other.defaultValue().equals(this.defaultValue())) {
            return false;
        }
        if (other.sourceFields() == null ^ this.sourceFields() == null) {
            return false;
        }
        if (other.sourceFields() != null && !other.sourceFields().equals(this.sourceFields())) {
            return false;
        }
        if (other.returnEnabled() == null ^ this.returnEnabled() == null) {
            return false;
        }
        if (other.returnEnabled() != null && !other.returnEnabled().equals(this.returnEnabled())) {
            return false;
        }
        if (other.highlightEnabled() == null ^ this.highlightEnabled() == null) {
            return false;
        }
        if (other.highlightEnabled() != null && !other.highlightEnabled().equals(this.highlightEnabled())) {
            return false;
        }
        if (other.analysisScheme() == null ^ this.analysisScheme() == null) {
            return false;
        }
        return other.analysisScheme() == null || other.analysisScheme().equals(this.analysisScheme());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.defaultValue() != null) {
            sb.append("DefaultValue: ").append(this.defaultValue()).append(",");
        }
        if (this.sourceFields() != null) {
            sb.append("SourceFields: ").append(this.sourceFields()).append(",");
        }
        if (this.returnEnabled() != null) {
            sb.append("ReturnEnabled: ").append(this.returnEnabled()).append(",");
        }
        if (this.highlightEnabled() != null) {
            sb.append("HighlightEnabled: ").append(this.highlightEnabled()).append(",");
        }
        if (this.analysisScheme() != null) {
            sb.append("AnalysisScheme: ").append(this.analysisScheme()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String defaultValue;
        private String sourceFields;
        private Boolean returnEnabled;
        private Boolean highlightEnabled;
        private String analysisScheme;

        private BuilderImpl() {
        }

        private BuilderImpl(TextArrayOptions model) {
            this.setDefaultValue(model.defaultValue);
            this.setSourceFields(model.sourceFields);
            this.setReturnEnabled(model.returnEnabled);
            this.setHighlightEnabled(model.highlightEnabled);
            this.setAnalysisScheme(model.analysisScheme);
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final String getSourceFields() {
            return this.sourceFields;
        }

        @Override
        public final Builder sourceFields(String sourceFields) {
            this.sourceFields = sourceFields;
            return this;
        }

        public final void setSourceFields(String sourceFields) {
            this.sourceFields = sourceFields;
        }

        public final Boolean getReturnEnabled() {
            return this.returnEnabled;
        }

        @Override
        public final Builder returnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
            return this;
        }

        public final void setReturnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
        }

        public final Boolean getHighlightEnabled() {
            return this.highlightEnabled;
        }

        @Override
        public final Builder highlightEnabled(Boolean highlightEnabled) {
            this.highlightEnabled = highlightEnabled;
            return this;
        }

        public final void setHighlightEnabled(Boolean highlightEnabled) {
            this.highlightEnabled = highlightEnabled;
        }

        public final String getAnalysisScheme() {
            return this.analysisScheme;
        }

        @Override
        public final Builder analysisScheme(String analysisScheme) {
            this.analysisScheme = analysisScheme;
            return this;
        }

        public final void setAnalysisScheme(String analysisScheme) {
            this.analysisScheme = analysisScheme;
        }

        public TextArrayOptions build() {
            return new TextArrayOptions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TextArrayOptions> {
        public Builder defaultValue(String var1);

        public Builder sourceFields(String var1);

        public Builder returnEnabled(Boolean var1);

        public Builder highlightEnabled(Boolean var1);

        public Builder analysisScheme(String var1);
    }
}

