/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.cloudsearch.model.DomainStatus;
import software.amazon.awssdk.services.cloudsearch.model.DomainStatusListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDomainsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeDomainsResponse> {
    private final List<DomainStatus> domainStatusList;

    private DescribeDomainsResponse(BuilderImpl builder) {
        this.domainStatusList = builder.domainStatusList;
    }

    public List<DomainStatus> domainStatusList() {
        return this.domainStatusList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainStatusList() == null ? 0 : this.domainStatusList().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainsResponse)) {
            return false;
        }
        DescribeDomainsResponse other = (DescribeDomainsResponse)((Object)obj);
        if (other.domainStatusList() == null ^ this.domainStatusList() == null) {
            return false;
        }
        return other.domainStatusList() == null || other.domainStatusList().equals(this.domainStatusList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domainStatusList() != null) {
            sb.append("DomainStatusList: ").append(this.domainStatusList()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<DomainStatus> domainStatusList;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainsResponse model) {
            this.setDomainStatusList(model.domainStatusList);
        }

        public final Collection<DomainStatus> getDomainStatusList() {
            return this.domainStatusList;
        }

        @Override
        public final Builder domainStatusList(Collection<DomainStatus> domainStatusList) {
            this.domainStatusList = DomainStatusListCopier.copy(domainStatusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainStatusList(DomainStatus ... domainStatusList) {
            this.domainStatusList(Arrays.asList(domainStatusList));
            return this;
        }

        public final void setDomainStatusList(Collection<DomainStatus> domainStatusList) {
            this.domainStatusList = DomainStatusListCopier.copy(domainStatusList);
        }

        @SafeVarargs
        public final void setDomainStatusList(DomainStatus ... domainStatusList) {
            this.domainStatusList(Arrays.asList(domainStatusList));
        }

        public DescribeDomainsResponse build() {
            return new DescribeDomainsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDomainsResponse> {
        public Builder domainStatusList(Collection<DomainStatus> var1);

        public Builder domainStatusList(DomainStatus ... var1);
    }
}

