/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudsearch.model.ScalingParameters;
import software.amazon.awssdk.services.cloudsearch.model.UpdateScalingParametersRequest;

public class UpdateScalingParametersRequestMarshaller
implements Marshaller<Request<UpdateScalingParametersRequest>, UpdateScalingParametersRequest> {
    public Request<UpdateScalingParametersRequest> marshall(UpdateScalingParametersRequest updateScalingParametersRequest) {
        ScalingParameters scalingParameters;
        if (updateScalingParametersRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)updateScalingParametersRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "UpdateScalingParameters");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateScalingParametersRequest.domainName() != null) {
            request.addParameter("DomainName", StringConversion.fromString((String)updateScalingParametersRequest.domainName()));
        }
        if ((scalingParameters = updateScalingParametersRequest.scalingParameters()) != null) {
            if (scalingParameters.desiredInstanceTypeAsString() != null) {
                request.addParameter("ScalingParameters.DesiredInstanceType", StringConversion.fromString((String)scalingParameters.desiredInstanceTypeAsString()));
            }
            if (scalingParameters.desiredReplicationCount() != null) {
                request.addParameter("ScalingParameters.DesiredReplicationCount", StringConversion.fromInteger((Integer)scalingParameters.desiredReplicationCount()));
            }
            if (scalingParameters.desiredPartitionCount() != null) {
                request.addParameter("ScalingParameters.DesiredPartitionCount", StringConversion.fromInteger((Integer)scalingParameters.desiredPartitionCount()));
            }
        }
        return request;
    }
}

