/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudsearch.model.DescribeExpressionsRequest;

public class DescribeExpressionsRequestMarshaller
implements Marshaller<Request<DescribeExpressionsRequest>, DescribeExpressionsRequest> {
    public Request<DescribeExpressionsRequest> marshall(DescribeExpressionsRequest describeExpressionsRequest) {
        if (describeExpressionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeExpressionsRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DescribeExpressions");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeExpressionsRequest.domainName() != null) {
            request.addParameter("DomainName", StringConversion.fromString((String)describeExpressionsRequest.domainName()));
        }
        if (describeExpressionsRequest.expressionNames().isEmpty() && !(describeExpressionsRequest.expressionNames() instanceof SdkAutoConstructList)) {
            request.addParameter("ExpressionNames", "");
        } else if (!describeExpressionsRequest.expressionNames().isEmpty() && !(describeExpressionsRequest.expressionNames() instanceof SdkAutoConstructList)) {
            List<String> expressionNamesList = describeExpressionsRequest.expressionNames();
            int expressionNamesListIndex = 1;
            for (String expressionNamesListValue : expressionNamesList) {
                if (expressionNamesListValue != null) {
                    request.addParameter("ExpressionNames.member." + expressionNamesListIndex, StringConversion.fromString((String)expressionNamesListValue));
                }
                ++expressionNamesListIndex;
            }
        }
        if (describeExpressionsRequest.deployed() != null) {
            request.addParameter("Deployed", StringConversion.fromBoolean((Boolean)describeExpressionsRequest.deployed()));
        }
        return request;
    }
}

