/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudsearch.model.AnalysisOptions;
import software.amazon.awssdk.services.cloudsearch.model.AnalysisScheme;
import software.amazon.awssdk.services.cloudsearch.model.DefineAnalysisSchemeRequest;

public class DefineAnalysisSchemeRequestMarshaller
implements Marshaller<Request<DefineAnalysisSchemeRequest>, DefineAnalysisSchemeRequest> {
    public Request<DefineAnalysisSchemeRequest> marshall(DefineAnalysisSchemeRequest defineAnalysisSchemeRequest) {
        AnalysisScheme analysisScheme;
        if (defineAnalysisSchemeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)defineAnalysisSchemeRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DefineAnalysisScheme");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (defineAnalysisSchemeRequest.domainName() != null) {
            request.addParameter("DomainName", StringConversion.fromString((String)defineAnalysisSchemeRequest.domainName()));
        }
        if ((analysisScheme = defineAnalysisSchemeRequest.analysisScheme()) != null) {
            AnalysisOptions analysisOptions;
            if (analysisScheme.analysisSchemeName() != null) {
                request.addParameter("AnalysisScheme.AnalysisSchemeName", StringConversion.fromString((String)analysisScheme.analysisSchemeName()));
            }
            if (analysisScheme.analysisSchemeLanguageAsString() != null) {
                request.addParameter("AnalysisScheme.AnalysisSchemeLanguage", StringConversion.fromString((String)analysisScheme.analysisSchemeLanguageAsString()));
            }
            if ((analysisOptions = analysisScheme.analysisOptions()) != null) {
                if (analysisOptions.synonyms() != null) {
                    request.addParameter("AnalysisScheme.AnalysisOptions.Synonyms", StringConversion.fromString((String)analysisOptions.synonyms()));
                }
                if (analysisOptions.stopwords() != null) {
                    request.addParameter("AnalysisScheme.AnalysisOptions.Stopwords", StringConversion.fromString((String)analysisOptions.stopwords()));
                }
                if (analysisOptions.stemmingDictionary() != null) {
                    request.addParameter("AnalysisScheme.AnalysisOptions.StemmingDictionary", StringConversion.fromString((String)analysisOptions.stemmingDictionary()));
                }
                if (analysisOptions.japaneseTokenizationDictionary() != null) {
                    request.addParameter("AnalysisScheme.AnalysisOptions.JapaneseTokenizationDictionary", StringConversion.fromString((String)analysisOptions.japaneseTokenizationDictionary()));
                }
                if (analysisOptions.algorithmicStemmingAsString() != null) {
                    request.addParameter("AnalysisScheme.AnalysisOptions.AlgorithmicStemming", StringConversion.fromString((String)analysisOptions.algorithmicStemmingAsString()));
                }
            }
        }
        return request;
    }
}

