/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.cloudsearch.model.PartitionInstanceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScalingParameters
implements ToCopyableBuilder<Builder, ScalingParameters> {
    private final String desiredInstanceType;
    private final Integer desiredReplicationCount;
    private final Integer desiredPartitionCount;

    private ScalingParameters(BuilderImpl builder) {
        this.desiredInstanceType = builder.desiredInstanceType;
        this.desiredReplicationCount = builder.desiredReplicationCount;
        this.desiredPartitionCount = builder.desiredPartitionCount;
    }

    public PartitionInstanceType desiredInstanceType() {
        return PartitionInstanceType.fromValue(this.desiredInstanceType);
    }

    public String desiredInstanceTypeAsString() {
        return this.desiredInstanceType;
    }

    public Integer desiredReplicationCount() {
        return this.desiredReplicationCount;
    }

    public Integer desiredPartitionCount() {
        return this.desiredPartitionCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredReplicationCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredPartitionCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingParameters)) {
            return false;
        }
        ScalingParameters other = (ScalingParameters)obj;
        return Objects.equals(this.desiredInstanceTypeAsString(), other.desiredInstanceTypeAsString()) && Objects.equals(this.desiredReplicationCount(), other.desiredReplicationCount()) && Objects.equals(this.desiredPartitionCount(), other.desiredPartitionCount());
    }

    public String toString() {
        return ToString.builder((String)"ScalingParameters").add("DesiredInstanceType", (Object)this.desiredInstanceTypeAsString()).add("DesiredReplicationCount", (Object)this.desiredReplicationCount()).add("DesiredPartitionCount", (Object)this.desiredPartitionCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DesiredInstanceType": {
                return Optional.ofNullable(clazz.cast(this.desiredInstanceTypeAsString()));
            }
            case "DesiredReplicationCount": {
                return Optional.ofNullable(clazz.cast(this.desiredReplicationCount()));
            }
            case "DesiredPartitionCount": {
                return Optional.ofNullable(clazz.cast(this.desiredPartitionCount()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String desiredInstanceType;
        private Integer desiredReplicationCount;
        private Integer desiredPartitionCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingParameters model) {
            this.desiredInstanceType(model.desiredInstanceType);
            this.desiredReplicationCount(model.desiredReplicationCount);
            this.desiredPartitionCount(model.desiredPartitionCount);
        }

        public final String getDesiredInstanceType() {
            return this.desiredInstanceType;
        }

        @Override
        public final Builder desiredInstanceType(String desiredInstanceType) {
            this.desiredInstanceType = desiredInstanceType;
            return this;
        }

        @Override
        public final Builder desiredInstanceType(PartitionInstanceType desiredInstanceType) {
            this.desiredInstanceType(desiredInstanceType.toString());
            return this;
        }

        public final void setDesiredInstanceType(String desiredInstanceType) {
            this.desiredInstanceType = desiredInstanceType;
        }

        public final Integer getDesiredReplicationCount() {
            return this.desiredReplicationCount;
        }

        @Override
        public final Builder desiredReplicationCount(Integer desiredReplicationCount) {
            this.desiredReplicationCount = desiredReplicationCount;
            return this;
        }

        public final void setDesiredReplicationCount(Integer desiredReplicationCount) {
            this.desiredReplicationCount = desiredReplicationCount;
        }

        public final Integer getDesiredPartitionCount() {
            return this.desiredPartitionCount;
        }

        @Override
        public final Builder desiredPartitionCount(Integer desiredPartitionCount) {
            this.desiredPartitionCount = desiredPartitionCount;
            return this;
        }

        public final void setDesiredPartitionCount(Integer desiredPartitionCount) {
            this.desiredPartitionCount = desiredPartitionCount;
        }

        public ScalingParameters build() {
            return new ScalingParameters(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScalingParameters> {
        public Builder desiredInstanceType(String var1);

        public Builder desiredInstanceType(PartitionInstanceType var1);

        public Builder desiredReplicationCount(Integer var1);

        public Builder desiredPartitionCount(Integer var1);
    }
}

