/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudsearch.model.DescribeAnalysisSchemesRequest;

public class DescribeAnalysisSchemesRequestMarshaller
implements Marshaller<Request<DescribeAnalysisSchemesRequest>, DescribeAnalysisSchemesRequest> {
    public Request<DescribeAnalysisSchemesRequest> marshall(DescribeAnalysisSchemesRequest describeAnalysisSchemesRequest) {
        if (describeAnalysisSchemesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeAnalysisSchemesRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DescribeAnalysisSchemes");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeAnalysisSchemesRequest.domainName() != null) {
            request.addParameter("DomainName", StringConversion.fromString((String)describeAnalysisSchemesRequest.domainName()));
        }
        if (describeAnalysisSchemesRequest.analysisSchemeNames().isEmpty() && !(describeAnalysisSchemesRequest.analysisSchemeNames() instanceof SdkAutoConstructList)) {
            request.addParameter("AnalysisSchemeNames", "");
        } else if (!describeAnalysisSchemesRequest.analysisSchemeNames().isEmpty() && !(describeAnalysisSchemesRequest.analysisSchemeNames() instanceof SdkAutoConstructList)) {
            List<String> analysisSchemeNamesList = describeAnalysisSchemesRequest.analysisSchemeNames();
            int analysisSchemeNamesListIndex = 1;
            for (String analysisSchemeNamesListValue : analysisSchemeNamesList) {
                if (analysisSchemeNamesListValue != null) {
                    request.addParameter("AnalysisSchemeNames.member." + analysisSchemeNamesListIndex, StringConversion.fromString((String)analysisSchemeNamesListValue));
                }
                ++analysisSchemeNamesListIndex;
            }
        }
        if (describeAnalysisSchemesRequest.deployed() != null) {
            request.addParameter("Deployed", StringConversion.fromBoolean((Boolean)describeAnalysisSchemesRequest.deployed()));
        }
        return request;
    }
}

