/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TextArrayOptions
implements ToCopyableBuilder<Builder, TextArrayOptions> {
    private final String defaultValue;
    private final String sourceFields;
    private final Boolean returnEnabled;
    private final Boolean highlightEnabled;
    private final String analysisScheme;

    private TextArrayOptions(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.sourceFields = builder.sourceFields;
        this.returnEnabled = builder.returnEnabled;
        this.highlightEnabled = builder.highlightEnabled;
        this.analysisScheme = builder.analysisScheme;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public String sourceFields() {
        return this.sourceFields;
    }

    public Boolean returnEnabled() {
        return this.returnEnabled;
    }

    public Boolean highlightEnabled() {
        return this.highlightEnabled;
    }

    public String analysisScheme() {
        return this.analysisScheme;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFields());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.highlightEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisScheme());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextArrayOptions)) {
            return false;
        }
        TextArrayOptions other = (TextArrayOptions)obj;
        return Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.sourceFields(), other.sourceFields()) && Objects.equals(this.returnEnabled(), other.returnEnabled()) && Objects.equals(this.highlightEnabled(), other.highlightEnabled()) && Objects.equals(this.analysisScheme(), other.analysisScheme());
    }

    public String toString() {
        return ToString.builder((String)"TextArrayOptions").add("DefaultValue", (Object)this.defaultValue()).add("SourceFields", (Object)this.sourceFields()).add("ReturnEnabled", (Object)this.returnEnabled()).add("HighlightEnabled", (Object)this.highlightEnabled()).add("AnalysisScheme", (Object)this.analysisScheme()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "SourceFields": {
                return Optional.ofNullable(clazz.cast(this.sourceFields()));
            }
            case "ReturnEnabled": {
                return Optional.ofNullable(clazz.cast(this.returnEnabled()));
            }
            case "HighlightEnabled": {
                return Optional.ofNullable(clazz.cast(this.highlightEnabled()));
            }
            case "AnalysisScheme": {
                return Optional.ofNullable(clazz.cast(this.analysisScheme()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String defaultValue;
        private String sourceFields;
        private Boolean returnEnabled;
        private Boolean highlightEnabled;
        private String analysisScheme;

        private BuilderImpl() {
        }

        private BuilderImpl(TextArrayOptions model) {
            this.defaultValue(model.defaultValue);
            this.sourceFields(model.sourceFields);
            this.returnEnabled(model.returnEnabled);
            this.highlightEnabled(model.highlightEnabled);
            this.analysisScheme(model.analysisScheme);
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final String getSourceFields() {
            return this.sourceFields;
        }

        @Override
        public final Builder sourceFields(String sourceFields) {
            this.sourceFields = sourceFields;
            return this;
        }

        public final void setSourceFields(String sourceFields) {
            this.sourceFields = sourceFields;
        }

        public final Boolean getReturnEnabled() {
            return this.returnEnabled;
        }

        @Override
        public final Builder returnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
            return this;
        }

        public final void setReturnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
        }

        public final Boolean getHighlightEnabled() {
            return this.highlightEnabled;
        }

        @Override
        public final Builder highlightEnabled(Boolean highlightEnabled) {
            this.highlightEnabled = highlightEnabled;
            return this;
        }

        public final void setHighlightEnabled(Boolean highlightEnabled) {
            this.highlightEnabled = highlightEnabled;
        }

        public final String getAnalysisScheme() {
            return this.analysisScheme;
        }

        @Override
        public final Builder analysisScheme(String analysisScheme) {
            this.analysisScheme = analysisScheme;
            return this;
        }

        public final void setAnalysisScheme(String analysisScheme) {
            this.analysisScheme = analysisScheme;
        }

        public TextArrayOptions build() {
            return new TextArrayOptions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TextArrayOptions> {
        public Builder defaultValue(String var1);

        public Builder sourceFields(String var1);

        public Builder returnEnabled(Boolean var1);

        public Builder highlightEnabled(Boolean var1);

        public Builder analysisScheme(String var1);
    }
}

