/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudhsmv2.model.Backup;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreBackupResponse
extends CloudHsmV2Response
implements ToCopyableBuilder<Builder, RestoreBackupResponse> {
    private static final SdkField<Backup> BACKUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Backup").getter(RestoreBackupResponse.getter(RestoreBackupResponse::backup)).setter(RestoreBackupResponse.setter(Builder::backup)).constructor(Backup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Backup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Backup", BACKUP_FIELD);
        }
    });
    private final Backup backup;

    private RestoreBackupResponse(BuilderImpl builder) {
        super(builder);
        this.backup = builder.backup;
    }

    public final Backup backup() {
        return this.backup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backup());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreBackupResponse)) {
            return false;
        }
        RestoreBackupResponse other = (RestoreBackupResponse)((Object)obj);
        return Objects.equals(this.backup(), other.backup());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreBackupResponse").add("Backup", (Object)this.backup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Backup": {
                return Optional.ofNullable(clazz.cast(this.backup()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RestoreBackupResponse, T> g) {
        return obj -> g.apply((RestoreBackupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudHsmV2Response.BuilderImpl
    implements Builder {
        private Backup backup;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreBackupResponse model) {
            super(model);
            this.backup(model.backup);
        }

        public final Backup.Builder getBackup() {
            return this.backup != null ? this.backup.toBuilder() : null;
        }

        public final void setBackup(Backup.BuilderImpl backup) {
            this.backup = backup != null ? backup.build() : null;
        }

        @Override
        public final Builder backup(Backup backup) {
            this.backup = backup;
            return this;
        }

        @Override
        public RestoreBackupResponse build() {
            return new RestoreBackupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudHsmV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreBackupResponse> {
        public Builder backup(Backup var1);

        default public Builder backup(Consumer<Backup.Builder> backup) {
            return this.backup((Backup)((Backup.Builder)Backup.builder().applyMutation(backup)).build());
        }
    }
}

