/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyBackupAttributesRequest
extends CloudHsmV2Request
implements ToCopyableBuilder<Builder, ModifyBackupAttributesRequest> {
    private static final SdkField<String> BACKUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupId").getter(ModifyBackupAttributesRequest.getter(ModifyBackupAttributesRequest::backupId)).setter(ModifyBackupAttributesRequest.setter(Builder::backupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupId").build()}).build();
    private static final SdkField<Boolean> NEVER_EXPIRES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NeverExpires").getter(ModifyBackupAttributesRequest.getter(ModifyBackupAttributesRequest::neverExpires)).setter(ModifyBackupAttributesRequest.setter(Builder::neverExpires)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NeverExpires").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_ID_FIELD, NEVER_EXPIRES_FIELD));
    private final String backupId;
    private final Boolean neverExpires;

    private ModifyBackupAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.backupId = builder.backupId;
        this.neverExpires = builder.neverExpires;
    }

    public final String backupId() {
        return this.backupId;
    }

    public final Boolean neverExpires() {
        return this.neverExpires;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.neverExpires());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyBackupAttributesRequest)) {
            return false;
        }
        ModifyBackupAttributesRequest other = (ModifyBackupAttributesRequest)((Object)obj);
        return Objects.equals(this.backupId(), other.backupId()) && Objects.equals(this.neverExpires(), other.neverExpires());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyBackupAttributesRequest").add("BackupId", (Object)this.backupId()).add("NeverExpires", (Object)this.neverExpires()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupId": {
                return Optional.ofNullable(clazz.cast(this.backupId()));
            }
            case "NeverExpires": {
                return Optional.ofNullable(clazz.cast(this.neverExpires()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyBackupAttributesRequest, T> g) {
        return obj -> g.apply((ModifyBackupAttributesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudHsmV2Request.BuilderImpl
    implements Builder {
        private String backupId;
        private Boolean neverExpires;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyBackupAttributesRequest model) {
            super(model);
            this.backupId(model.backupId);
            this.neverExpires(model.neverExpires);
        }

        public final String getBackupId() {
            return this.backupId;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final Boolean getNeverExpires() {
            return this.neverExpires;
        }

        public final void setNeverExpires(Boolean neverExpires) {
            this.neverExpires = neverExpires;
        }

        @Override
        public final Builder neverExpires(Boolean neverExpires) {
            this.neverExpires = neverExpires;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyBackupAttributesRequest build() {
            return new ModifyBackupAttributesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudHsmV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyBackupAttributesRequest> {
        public Builder backupId(String var1);

        public Builder neverExpires(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

