/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.model.Certificates;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CertificatesMarshaller {
    private static final MarshallingInfo<String> CLUSTERCSR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterCsr").isBinary(false).build();
    private static final MarshallingInfo<String> HSMCERTIFICATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HsmCertificate").isBinary(false).build();
    private static final MarshallingInfo<String> AWSHARDWARECERTIFICATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AwsHardwareCertificate").isBinary(false).build();
    private static final MarshallingInfo<String> MANUFACTURERHARDWARECERTIFICATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ManufacturerHardwareCertificate").isBinary(false).build();
    private static final MarshallingInfo<String> CLUSTERCERTIFICATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterCertificate").isBinary(false).build();
    private static final CertificatesMarshaller INSTANCE = new CertificatesMarshaller();

    private CertificatesMarshaller() {
    }

    public static CertificatesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Certificates certificates, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)certificates, (String)"certificates");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)certificates.clusterCsr(), CLUSTERCSR_BINDING);
            protocolMarshaller.marshall((Object)certificates.hsmCertificate(), HSMCERTIFICATE_BINDING);
            protocolMarshaller.marshall((Object)certificates.awsHardwareCertificate(), AWSHARDWARECERTIFICATE_BINDING);
            protocolMarshaller.marshall((Object)certificates.manufacturerHardwareCertificate(), MANUFACTURERHARDWARECERTIFICATE_BINDING);
            protocolMarshaller.marshall((Object)certificates.clusterCertificate(), CLUSTERCERTIFICATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

