/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudhsmv2.model.BackupState;
import software.amazon.awssdk.services.cloudhsmv2.transform.BackupMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Backup
implements StructuredPojo,
ToCopyableBuilder<Builder, Backup> {
    private final String backupId;
    private final String backupState;
    private final String clusterId;
    private final Instant createTimestamp;

    private Backup(BuilderImpl builder) {
        this.backupId = builder.backupId;
        this.backupState = builder.backupState;
        this.clusterId = builder.clusterId;
        this.createTimestamp = builder.createTimestamp;
    }

    public String backupId() {
        return this.backupId;
    }

    public BackupState backupState() {
        return BackupState.fromValue(this.backupState);
    }

    public String backupStateString() {
        return this.backupState;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public Instant createTimestamp() {
        return this.createTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupStateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Backup)) {
            return false;
        }
        Backup other = (Backup)obj;
        return Objects.equals(this.backupId(), other.backupId()) && Objects.equals(this.backupStateString(), other.backupStateString()) && Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.createTimestamp(), other.createTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"Backup").add("BackupId", (Object)this.backupId()).add("BackupState", (Object)this.backupStateString()).add("ClusterId", (Object)this.clusterId()).add("CreateTimestamp", (Object)this.createTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupId": {
                return Optional.of(clazz.cast(this.backupId()));
            }
            case "BackupState": {
                return Optional.of(clazz.cast(this.backupStateString()));
            }
            case "ClusterId": {
                return Optional.of(clazz.cast(this.clusterId()));
            }
            case "CreateTimestamp": {
                return Optional.of(clazz.cast(this.createTimestamp()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BackupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String backupId;
        private String backupState;
        private String clusterId;
        private Instant createTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Backup model) {
            this.backupId(model.backupId);
            this.backupState(model.backupState);
            this.clusterId(model.clusterId);
            this.createTimestamp(model.createTimestamp);
        }

        public final String getBackupId() {
            return this.backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        public final String getBackupState() {
            return this.backupState;
        }

        @Override
        public final Builder backupState(String backupState) {
            this.backupState = backupState;
            return this;
        }

        @Override
        public final Builder backupState(BackupState backupState) {
            this.backupState(backupState.toString());
            return this;
        }

        public final void setBackupState(String backupState) {
            this.backupState = backupState;
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final Instant getCreateTimestamp() {
            return this.createTimestamp;
        }

        @Override
        public final Builder createTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public final void setCreateTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
        }

        public Backup build() {
            return new Backup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Backup> {
        public Builder backupId(String var1);

        public Builder backupState(String var1);

        public Builder backupState(BackupState var1);

        public Builder clusterId(String var1);

        public Builder createTimestamp(Instant var1);
    }
}

