/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.model.DestinationBackup;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DestinationBackupMarshaller {
    private static final MarshallingInfo<Instant> CREATETIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreateTimestamp").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCEREGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceRegion").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCEBACKUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceBackup").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCECLUSTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceCluster").isBinary(false).build();
    private static final DestinationBackupMarshaller INSTANCE = new DestinationBackupMarshaller();

    private DestinationBackupMarshaller() {
    }

    public static DestinationBackupMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DestinationBackup destinationBackup, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)destinationBackup, (String)"destinationBackup");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)destinationBackup.createTimestamp(), CREATETIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)destinationBackup.sourceRegion(), SOURCEREGION_BINDING);
            protocolMarshaller.marshall((Object)destinationBackup.sourceBackup(), SOURCEBACKUP_BINDING);
            protocolMarshaller.marshall((Object)destinationBackup.sourceCluster(), SOURCECLUSTER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

