/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudhsmv2.transform.DestinationBackupMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DestinationBackup
implements StructuredPojo,
ToCopyableBuilder<Builder, DestinationBackup> {
    private final Instant createTimestamp;
    private final String sourceRegion;
    private final String sourceBackup;
    private final String sourceCluster;

    private DestinationBackup(BuilderImpl builder) {
        this.createTimestamp = builder.createTimestamp;
        this.sourceRegion = builder.sourceRegion;
        this.sourceBackup = builder.sourceBackup;
        this.sourceCluster = builder.sourceCluster;
    }

    public Instant createTimestamp() {
        return this.createTimestamp;
    }

    public String sourceRegion() {
        return this.sourceRegion;
    }

    public String sourceBackup() {
        return this.sourceBackup;
    }

    public String sourceCluster() {
        return this.sourceCluster;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBackup());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCluster());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationBackup)) {
            return false;
        }
        DestinationBackup other = (DestinationBackup)obj;
        return Objects.equals(this.createTimestamp(), other.createTimestamp()) && Objects.equals(this.sourceRegion(), other.sourceRegion()) && Objects.equals(this.sourceBackup(), other.sourceBackup()) && Objects.equals(this.sourceCluster(), other.sourceCluster());
    }

    public String toString() {
        return ToString.builder((String)"DestinationBackup").add("CreateTimestamp", (Object)this.createTimestamp()).add("SourceRegion", (Object)this.sourceRegion()).add("SourceBackup", (Object)this.sourceBackup()).add("SourceCluster", (Object)this.sourceCluster()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createTimestamp()));
            }
            case "SourceRegion": {
                return Optional.ofNullable(clazz.cast(this.sourceRegion()));
            }
            case "SourceBackup": {
                return Optional.ofNullable(clazz.cast(this.sourceBackup()));
            }
            case "SourceCluster": {
                return Optional.ofNullable(clazz.cast(this.sourceCluster()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DestinationBackupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createTimestamp;
        private String sourceRegion;
        private String sourceBackup;
        private String sourceCluster;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationBackup model) {
            this.createTimestamp(model.createTimestamp);
            this.sourceRegion(model.sourceRegion);
            this.sourceBackup(model.sourceBackup);
            this.sourceCluster(model.sourceCluster);
        }

        public final Instant getCreateTimestamp() {
            return this.createTimestamp;
        }

        @Override
        public final Builder createTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public final void setCreateTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        public final String getSourceBackup() {
            return this.sourceBackup;
        }

        @Override
        public final Builder sourceBackup(String sourceBackup) {
            this.sourceBackup = sourceBackup;
            return this;
        }

        public final void setSourceBackup(String sourceBackup) {
            this.sourceBackup = sourceBackup;
        }

        public final String getSourceCluster() {
            return this.sourceCluster;
        }

        @Override
        public final Builder sourceCluster(String sourceCluster) {
            this.sourceCluster = sourceCluster;
            return this;
        }

        public final void setSourceCluster(String sourceCluster) {
            this.sourceCluster = sourceCluster;
        }

        public DestinationBackup build() {
            return new DestinationBackup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DestinationBackup> {
        public Builder createTimestamp(Instant var1);

        public Builder sourceRegion(String var1);

        public Builder sourceBackup(String var1);

        public Builder sourceCluster(String var1);
    }
}

