/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyBackupToRegionRequest
extends CloudHsmV2Request
implements ToCopyableBuilder<Builder, CopyBackupToRegionRequest> {
    private final String destinationRegion;
    private final String backupId;

    private CopyBackupToRegionRequest(BuilderImpl builder) {
        super(builder);
        this.destinationRegion = builder.destinationRegion;
        this.backupId = builder.backupId;
    }

    public String destinationRegion() {
        return this.destinationRegion;
    }

    public String backupId() {
        return this.backupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyBackupToRegionRequest)) {
            return false;
        }
        CopyBackupToRegionRequest other = (CopyBackupToRegionRequest)((Object)obj);
        return Objects.equals(this.destinationRegion(), other.destinationRegion()) && Objects.equals(this.backupId(), other.backupId());
    }

    public String toString() {
        return ToString.builder((String)"CopyBackupToRegionRequest").add("DestinationRegion", (Object)this.destinationRegion()).add("BackupId", (Object)this.backupId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationRegion": {
                return Optional.ofNullable(clazz.cast(this.destinationRegion()));
            }
            case "BackupId": {
                return Optional.ofNullable(clazz.cast(this.backupId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudHsmV2Request.BuilderImpl
    implements Builder {
        private String destinationRegion;
        private String backupId;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyBackupToRegionRequest model) {
            super(model);
            this.destinationRegion(model.destinationRegion);
            this.backupId(model.backupId);
        }

        public final String getDestinationRegion() {
            return this.destinationRegion;
        }

        @Override
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        public final String getBackupId() {
            return this.backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyBackupToRegionRequest build() {
            return new CopyBackupToRegionRequest(this);
        }
    }

    public static interface Builder
    extends CloudHsmV2Request.Builder,
    CopyableBuilder<Builder, CopyBackupToRegionRequest> {
        public Builder destinationRegion(String var1);

        public Builder backupId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

