/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudhsmv2.model.BackupState;
import software.amazon.awssdk.services.cloudhsmv2.transform.BackupMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Backup
implements StructuredPojo,
ToCopyableBuilder<Builder, Backup> {
    private final String backupId;
    private final String backupState;
    private final String clusterId;
    private final Instant createTimestamp;
    private final Instant copyTimestamp;
    private final String sourceRegion;
    private final String sourceBackup;
    private final String sourceCluster;

    private Backup(BuilderImpl builder) {
        this.backupId = builder.backupId;
        this.backupState = builder.backupState;
        this.clusterId = builder.clusterId;
        this.createTimestamp = builder.createTimestamp;
        this.copyTimestamp = builder.copyTimestamp;
        this.sourceRegion = builder.sourceRegion;
        this.sourceBackup = builder.sourceBackup;
        this.sourceCluster = builder.sourceCluster;
    }

    public String backupId() {
        return this.backupId;
    }

    public BackupState backupState() {
        return BackupState.fromValue(this.backupState);
    }

    public String backupStateAsString() {
        return this.backupState;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public Instant createTimestamp() {
        return this.createTimestamp;
    }

    public Instant copyTimestamp() {
        return this.copyTimestamp;
    }

    public String sourceRegion() {
        return this.sourceRegion;
    }

    public String sourceBackup() {
        return this.sourceBackup;
    }

    public String sourceCluster() {
        return this.sourceCluster;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBackup());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCluster());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Backup)) {
            return false;
        }
        Backup other = (Backup)obj;
        return Objects.equals(this.backupId(), other.backupId()) && Objects.equals(this.backupStateAsString(), other.backupStateAsString()) && Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.createTimestamp(), other.createTimestamp()) && Objects.equals(this.copyTimestamp(), other.copyTimestamp()) && Objects.equals(this.sourceRegion(), other.sourceRegion()) && Objects.equals(this.sourceBackup(), other.sourceBackup()) && Objects.equals(this.sourceCluster(), other.sourceCluster());
    }

    public String toString() {
        return ToString.builder((String)"Backup").add("BackupId", (Object)this.backupId()).add("BackupState", (Object)this.backupStateAsString()).add("ClusterId", (Object)this.clusterId()).add("CreateTimestamp", (Object)this.createTimestamp()).add("CopyTimestamp", (Object)this.copyTimestamp()).add("SourceRegion", (Object)this.sourceRegion()).add("SourceBackup", (Object)this.sourceBackup()).add("SourceCluster", (Object)this.sourceCluster()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupId": {
                return Optional.ofNullable(clazz.cast(this.backupId()));
            }
            case "BackupState": {
                return Optional.ofNullable(clazz.cast(this.backupStateAsString()));
            }
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "CreateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createTimestamp()));
            }
            case "CopyTimestamp": {
                return Optional.ofNullable(clazz.cast(this.copyTimestamp()));
            }
            case "SourceRegion": {
                return Optional.ofNullable(clazz.cast(this.sourceRegion()));
            }
            case "SourceBackup": {
                return Optional.ofNullable(clazz.cast(this.sourceBackup()));
            }
            case "SourceCluster": {
                return Optional.ofNullable(clazz.cast(this.sourceCluster()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BackupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String backupId;
        private String backupState;
        private String clusterId;
        private Instant createTimestamp;
        private Instant copyTimestamp;
        private String sourceRegion;
        private String sourceBackup;
        private String sourceCluster;

        private BuilderImpl() {
        }

        private BuilderImpl(Backup model) {
            this.backupId(model.backupId);
            this.backupState(model.backupState);
            this.clusterId(model.clusterId);
            this.createTimestamp(model.createTimestamp);
            this.copyTimestamp(model.copyTimestamp);
            this.sourceRegion(model.sourceRegion);
            this.sourceBackup(model.sourceBackup);
            this.sourceCluster(model.sourceCluster);
        }

        public final String getBackupId() {
            return this.backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        public final String getBackupState() {
            return this.backupState;
        }

        @Override
        public final Builder backupState(String backupState) {
            this.backupState = backupState;
            return this;
        }

        @Override
        public final Builder backupState(BackupState backupState) {
            this.backupState(backupState.toString());
            return this;
        }

        public final void setBackupState(String backupState) {
            this.backupState = backupState;
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final Instant getCreateTimestamp() {
            return this.createTimestamp;
        }

        @Override
        public final Builder createTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public final void setCreateTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
        }

        public final Instant getCopyTimestamp() {
            return this.copyTimestamp;
        }

        @Override
        public final Builder copyTimestamp(Instant copyTimestamp) {
            this.copyTimestamp = copyTimestamp;
            return this;
        }

        public final void setCopyTimestamp(Instant copyTimestamp) {
            this.copyTimestamp = copyTimestamp;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        public final String getSourceBackup() {
            return this.sourceBackup;
        }

        @Override
        public final Builder sourceBackup(String sourceBackup) {
            this.sourceBackup = sourceBackup;
            return this;
        }

        public final void setSourceBackup(String sourceBackup) {
            this.sourceBackup = sourceBackup;
        }

        public final String getSourceCluster() {
            return this.sourceCluster;
        }

        @Override
        public final Builder sourceCluster(String sourceCluster) {
            this.sourceCluster = sourceCluster;
            return this;
        }

        public final void setSourceCluster(String sourceCluster) {
            this.sourceCluster = sourceCluster;
        }

        public Backup build() {
            return new Backup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Backup> {
        public Builder backupId(String var1);

        public Builder backupState(String var1);

        public Builder backupState(BackupState var1);

        public Builder clusterId(String var1);

        public Builder createTimestamp(Instant var1);

        public Builder copyTimestamp(Instant var1);

        public Builder sourceRegion(String var1);

        public Builder sourceBackup(String var1);

        public Builder sourceCluster(String var1);
    }
}

