/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudhsmv2.CloudHsmV2Client;
import software.amazon.awssdk.services.cloudhsmv2.model.ListTagsRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.ListTagsResponse;

public class ListTagsIterable
implements SdkIterable<ListTagsResponse> {
    private final CloudHsmV2Client client;
    private final ListTagsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTagsIterable(CloudHsmV2Client client, ListTagsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTagsResponseFetcher();
    }

    public Iterator<ListTagsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListTagsIterable resume(ListTagsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListTagsIterable(this.client, (ListTagsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListTagsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListTagsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListTagsResponseFetcher
    implements SyncPageFetcher<ListTagsResponse> {
        private ListTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListTagsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public ListTagsResponse nextPage(ListTagsResponse previousPage) {
            if (previousPage == null) {
                return ListTagsIterable.this.client.listTags(ListTagsIterable.this.firstRequest);
            }
            return ListTagsIterable.this.client.listTags((ListTagsRequest)((Object)ListTagsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

