/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.transform;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudhsmv2.model.Cluster;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ClusterMarshaller {
    private static final MarshallingInfo<String> BACKUPPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupPolicy").isBinary(false).build();
    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATETIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreateTimestamp").isBinary(false).build();
    private static final MarshallingInfo<List> HSMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Hsms").isBinary(false).build();
    private static final MarshallingInfo<String> HSMTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HsmType").isBinary(false).build();
    private static final MarshallingInfo<String> PRECOPASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PreCoPassword").isBinary(false).build();
    private static final MarshallingInfo<String> SECURITYGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroup").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCEBACKUPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceBackupId").isBinary(false).build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").isBinary(false).build();
    private static final MarshallingInfo<String> STATEMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateMessage").isBinary(false).build();
    private static final MarshallingInfo<Map> SUBNETMAPPING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetMapping").isBinary(false).build();
    private static final MarshallingInfo<String> VPCID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CERTIFICATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Certificates").isBinary(false).build();
    private static final ClusterMarshaller INSTANCE = new ClusterMarshaller();

    private ClusterMarshaller() {
    }

    public static ClusterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Cluster cluster, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)cluster, (String)"cluster");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)cluster.backupPolicyAsString(), BACKUPPOLICY_BINDING);
            protocolMarshaller.marshall((Object)cluster.clusterId(), CLUSTERID_BINDING);
            protocolMarshaller.marshall((Object)cluster.createTimestamp(), CREATETIMESTAMP_BINDING);
            protocolMarshaller.marshall(cluster.hsms(), HSMS_BINDING);
            protocolMarshaller.marshall((Object)cluster.hsmType(), HSMTYPE_BINDING);
            protocolMarshaller.marshall((Object)cluster.preCoPassword(), PRECOPASSWORD_BINDING);
            protocolMarshaller.marshall((Object)cluster.securityGroup(), SECURITYGROUP_BINDING);
            protocolMarshaller.marshall((Object)cluster.sourceBackupId(), SOURCEBACKUPID_BINDING);
            protocolMarshaller.marshall((Object)cluster.stateAsString(), STATE_BINDING);
            protocolMarshaller.marshall((Object)cluster.stateMessage(), STATEMESSAGE_BINDING);
            protocolMarshaller.marshall(cluster.subnetMapping(), SUBNETMAPPING_BINDING);
            protocolMarshaller.marshall((Object)cluster.vpcId(), VPCID_BINDING);
            protocolMarshaller.marshall((Object)cluster.certificates(), CERTIFICATES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

