/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudhsmv2.model.HsmState;
import software.amazon.awssdk.services.cloudhsmv2.transform.HsmMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Hsm
implements StructuredPojo,
ToCopyableBuilder<Builder, Hsm> {
    private final String availabilityZone;
    private final String clusterId;
    private final String subnetId;
    private final String eniId;
    private final String eniIp;
    private final String hsmId;
    private final String state;
    private final String stateMessage;

    private Hsm(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.clusterId = builder.clusterId;
        this.subnetId = builder.subnetId;
        this.eniId = builder.eniId;
        this.eniIp = builder.eniIp;
        this.hsmId = builder.hsmId;
        this.state = builder.state;
        this.stateMessage = builder.stateMessage;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String eniId() {
        return this.eniId;
    }

    public String eniIp() {
        return this.eniIp;
    }

    public String hsmId() {
        return this.hsmId;
    }

    public HsmState state() {
        return HsmState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String stateMessage() {
        return this.stateMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eniId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eniIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Hsm)) {
            return false;
        }
        Hsm other = (Hsm)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.eniId(), other.eniId()) && Objects.equals(this.eniIp(), other.eniIp()) && Objects.equals(this.hsmId(), other.hsmId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateMessage(), other.stateMessage());
    }

    public String toString() {
        return ToString.builder((String)"Hsm").add("AvailabilityZone", (Object)this.availabilityZone()).add("ClusterId", (Object)this.clusterId()).add("SubnetId", (Object)this.subnetId()).add("EniId", (Object)this.eniId()).add("EniIp", (Object)this.eniIp()).add("HsmId", (Object)this.hsmId()).add("State", (Object)this.stateAsString()).add("StateMessage", (Object)this.stateMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "ClusterId": {
                return Optional.of(clazz.cast(this.clusterId()));
            }
            case "SubnetId": {
                return Optional.of(clazz.cast(this.subnetId()));
            }
            case "EniId": {
                return Optional.of(clazz.cast(this.eniId()));
            }
            case "EniIp": {
                return Optional.of(clazz.cast(this.eniIp()));
            }
            case "HsmId": {
                return Optional.of(clazz.cast(this.hsmId()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateAsString()));
            }
            case "StateMessage": {
                return Optional.of(clazz.cast(this.stateMessage()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HsmMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String clusterId;
        private String subnetId;
        private String eniId;
        private String eniIp;
        private String hsmId;
        private String state;
        private String stateMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(Hsm model) {
            this.availabilityZone(model.availabilityZone);
            this.clusterId(model.clusterId);
            this.subnetId(model.subnetId);
            this.eniId(model.eniId);
            this.eniIp(model.eniIp);
            this.hsmId(model.hsmId);
            this.state(model.state);
            this.stateMessage(model.stateMessage);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getEniId() {
            return this.eniId;
        }

        @Override
        public final Builder eniId(String eniId) {
            this.eniId = eniId;
            return this;
        }

        public final void setEniId(String eniId) {
            this.eniId = eniId;
        }

        public final String getEniIp() {
            return this.eniIp;
        }

        @Override
        public final Builder eniIp(String eniIp) {
            this.eniIp = eniIp;
            return this;
        }

        public final void setEniIp(String eniIp) {
            this.eniIp = eniIp;
        }

        public final String getHsmId() {
            return this.hsmId;
        }

        @Override
        public final Builder hsmId(String hsmId) {
            this.hsmId = hsmId;
            return this;
        }

        public final void setHsmId(String hsmId) {
            this.hsmId = hsmId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(HsmState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateMessage() {
            return this.stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        public Hsm build() {
            return new Hsm(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Hsm> {
        public Builder availabilityZone(String var1);

        public Builder clusterId(String var1);

        public Builder subnetId(String var1);

        public Builder eniId(String var1);

        public Builder eniIp(String var1);

        public Builder hsmId(String var1);

        public Builder state(String var1);

        public Builder state(HsmState var1);

        public Builder stateMessage(String var1);
    }
}

