/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHSMV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteHsmRequest
extends CloudHSMV2Request
implements ToCopyableBuilder<Builder, DeleteHsmRequest> {
    private final String clusterId;
    private final String hsmId;
    private final String eniId;
    private final String eniIp;

    private DeleteHsmRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.hsmId = builder.hsmId;
        this.eniId = builder.eniId;
        this.eniIp = builder.eniIp;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public String hsmId() {
        return this.hsmId;
    }

    public String eniId() {
        return this.eniId;
    }

    public String eniIp() {
        return this.eniIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eniId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eniIp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteHsmRequest)) {
            return false;
        }
        DeleteHsmRequest other = (DeleteHsmRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.hsmId(), other.hsmId()) && Objects.equals(this.eniId(), other.eniId()) && Objects.equals(this.eniIp(), other.eniIp());
    }

    public String toString() {
        return ToString.builder((String)"DeleteHsmRequest").add("ClusterId", (Object)this.clusterId()).add("HsmId", (Object)this.hsmId()).add("EniId", (Object)this.eniId()).add("EniIp", (Object)this.eniIp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.of(clazz.cast(this.clusterId()));
            }
            case "HsmId": {
                return Optional.of(clazz.cast(this.hsmId()));
            }
            case "EniId": {
                return Optional.of(clazz.cast(this.eniId()));
            }
            case "EniIp": {
                return Optional.of(clazz.cast(this.eniIp()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudHSMV2Request.BuilderImpl
    implements Builder {
        private String clusterId;
        private String hsmId;
        private String eniId;
        private String eniIp;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteHsmRequest model) {
            super(model);
            this.clusterId(model.clusterId);
            this.hsmId(model.hsmId);
            this.eniId(model.eniId);
            this.eniIp(model.eniIp);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getHsmId() {
            return this.hsmId;
        }

        @Override
        public final Builder hsmId(String hsmId) {
            this.hsmId = hsmId;
            return this;
        }

        public final void setHsmId(String hsmId) {
            this.hsmId = hsmId;
        }

        public final String getEniId() {
            return this.eniId;
        }

        @Override
        public final Builder eniId(String eniId) {
            this.eniId = eniId;
            return this;
        }

        public final void setEniId(String eniId) {
            this.eniId = eniId;
        }

        public final String getEniIp() {
            return this.eniIp;
        }

        @Override
        public final Builder eniIp(String eniIp) {
            this.eniIp = eniIp;
            return this;
        }

        public final void setEniIp(String eniIp) {
            this.eniIp = eniIp;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteHsmRequest build() {
            return new DeleteHsmRequest(this);
        }
    }

    public static interface Builder
    extends CloudHSMV2Request.Builder,
    CopyableBuilder<Builder, DeleteHsmRequest> {
        public Builder clusterId(String var1);

        public Builder hsmId(String var1);

        public Builder eniId(String var1);

        public Builder eniIp(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

