/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHSMV2Request;
import software.amazon.awssdk.services.cloudhsmv2.model.SubnetIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateClusterRequest
extends CloudHSMV2Request
implements ToCopyableBuilder<Builder, CreateClusterRequest> {
    private final List<String> subnetIds;
    private final String hsmType;
    private final String sourceBackupId;

    private CreateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.subnetIds = builder.subnetIds;
        this.hsmType = builder.hsmType;
        this.sourceBackupId = builder.sourceBackupId;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public String hsmType() {
        return this.hsmType;
    }

    public String sourceBackupId() {
        return this.sourceBackupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmType());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBackupId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest)((Object)obj);
        return Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.hsmType(), other.hsmType()) && Objects.equals(this.sourceBackupId(), other.sourceBackupId());
    }

    public String toString() {
        return ToString.builder((String)"CreateClusterRequest").add("SubnetIds", this.subnetIds()).add("HsmType", (Object)this.hsmType()).add("SourceBackupId", (Object)this.sourceBackupId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetIds": {
                return Optional.of(clazz.cast(this.subnetIds()));
            }
            case "HsmType": {
                return Optional.of(clazz.cast(this.hsmType()));
            }
            case "SourceBackupId": {
                return Optional.of(clazz.cast(this.sourceBackupId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudHSMV2Request.BuilderImpl
    implements Builder {
        private List<String> subnetIds;
        private String hsmType;
        private String sourceBackupId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            super(model);
            this.subnetIds(model.subnetIds);
            this.hsmType(model.hsmType);
            this.sourceBackupId(model.sourceBackupId);
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        public final String getHsmType() {
            return this.hsmType;
        }

        @Override
        public final Builder hsmType(String hsmType) {
            this.hsmType = hsmType;
            return this;
        }

        public final void setHsmType(String hsmType) {
            this.hsmType = hsmType;
        }

        public final String getSourceBackupId() {
            return this.sourceBackupId;
        }

        @Override
        public final Builder sourceBackupId(String sourceBackupId) {
            this.sourceBackupId = sourceBackupId;
            return this;
        }

        public final void setSourceBackupId(String sourceBackupId) {
            this.sourceBackupId = sourceBackupId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }
    }

    public static interface Builder
    extends CloudHSMV2Request.Builder,
    CopyableBuilder<Builder, CreateClusterRequest> {
        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder hsmType(String var1);

        public Builder sourceBackupId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

