/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudhsm.CloudHsmClient;
import software.amazon.awssdk.services.cloudhsm.CloudHsmClientBuilder;
import software.amazon.awssdk.services.cloudhsm.CloudHsmServiceClientConfiguration;
import software.amazon.awssdk.services.cloudhsm.DefaultCloudHsmBaseClientBuilder;
import software.amazon.awssdk.services.cloudhsm.DefaultCloudHsmClient;
import software.amazon.awssdk.services.cloudhsm.endpoints.CloudHsmEndpointProvider;

@SdkInternalApi
final class DefaultCloudHsmClientBuilder
extends DefaultCloudHsmBaseClientBuilder<CloudHsmClientBuilder, CloudHsmClient>
implements CloudHsmClientBuilder {
    DefaultCloudHsmClientBuilder() {
    }

    @Override
    public DefaultCloudHsmClientBuilder endpointProvider(CloudHsmEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CloudHsmClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCloudHsmClientBuilder.validateClientOptions(clientConfiguration);
        CloudHsmServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCloudHsmClient client = new DefaultCloudHsmClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CloudHsmServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CloudHsmServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

