/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudhsm.model.CloudHsmRequest;
import software.amazon.awssdk.services.cloudhsm.model.PartitionSerialListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyHapgRequest
extends CloudHsmRequest
implements ToCopyableBuilder<Builder, ModifyHapgRequest> {
    private static final SdkField<String> HAPG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HapgArn").getter(ModifyHapgRequest.getter(ModifyHapgRequest::hapgArn)).setter(ModifyHapgRequest.setter(Builder::hapgArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HapgArn").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Label").getter(ModifyHapgRequest.getter(ModifyHapgRequest::label)).setter(ModifyHapgRequest.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()}).build();
    private static final SdkField<List<String>> PARTITION_SERIAL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PartitionSerialList").getter(ModifyHapgRequest.getter(ModifyHapgRequest::partitionSerialList)).setter(ModifyHapgRequest.setter(Builder::partitionSerialList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionSerialList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HAPG_ARN_FIELD, LABEL_FIELD, PARTITION_SERIAL_LIST_FIELD));
    private final String hapgArn;
    private final String label;
    private final List<String> partitionSerialList;

    private ModifyHapgRequest(BuilderImpl builder) {
        super(builder);
        this.hapgArn = builder.hapgArn;
        this.label = builder.label;
        this.partitionSerialList = builder.partitionSerialList;
    }

    public final String hapgArn() {
        return this.hapgArn;
    }

    public final String label() {
        return this.label;
    }

    public final boolean hasPartitionSerialList() {
        return this.partitionSerialList != null && !(this.partitionSerialList instanceof SdkAutoConstructList);
    }

    public final List<String> partitionSerialList() {
        return this.partitionSerialList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hapgArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitionSerialList() ? this.partitionSerialList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyHapgRequest)) {
            return false;
        }
        ModifyHapgRequest other = (ModifyHapgRequest)((Object)obj);
        return Objects.equals(this.hapgArn(), other.hapgArn()) && Objects.equals(this.label(), other.label()) && this.hasPartitionSerialList() == other.hasPartitionSerialList() && Objects.equals(this.partitionSerialList(), other.partitionSerialList());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyHapgRequest").add("HapgArn", (Object)this.hapgArn()).add("Label", (Object)this.label()).add("PartitionSerialList", this.hasPartitionSerialList() ? this.partitionSerialList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HapgArn": {
                return Optional.ofNullable(clazz.cast(this.hapgArn()));
            }
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "PartitionSerialList": {
                return Optional.ofNullable(clazz.cast(this.partitionSerialList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyHapgRequest, T> g) {
        return obj -> g.apply((ModifyHapgRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudHsmRequest.BuilderImpl
    implements Builder {
        private String hapgArn;
        private String label;
        private List<String> partitionSerialList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyHapgRequest model) {
            super(model);
            this.hapgArn(model.hapgArn);
            this.label(model.label);
            this.partitionSerialList(model.partitionSerialList);
        }

        public final String getHapgArn() {
            return this.hapgArn;
        }

        @Override
        public final Builder hapgArn(String hapgArn) {
            this.hapgArn = hapgArn;
            return this;
        }

        public final void setHapgArn(String hapgArn) {
            this.hapgArn = hapgArn;
        }

        public final String getLabel() {
            return this.label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final Collection<String> getPartitionSerialList() {
            if (this.partitionSerialList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.partitionSerialList;
        }

        @Override
        public final Builder partitionSerialList(Collection<String> partitionSerialList) {
            this.partitionSerialList = PartitionSerialListCopier.copy(partitionSerialList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionSerialList(String ... partitionSerialList) {
            this.partitionSerialList(Arrays.asList(partitionSerialList));
            return this;
        }

        public final void setPartitionSerialList(Collection<String> partitionSerialList) {
            this.partitionSerialList = PartitionSerialListCopier.copy(partitionSerialList);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyHapgRequest build() {
            return new ModifyHapgRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudHsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyHapgRequest> {
        public Builder hapgArn(String var1);

        public Builder label(String var1);

        public Builder partitionSerialList(Collection<String> var1);

        public Builder partitionSerialList(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

