/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudhsm.model.CloudHsmResponse;
import software.amazon.awssdk.services.cloudhsm.model.HsmListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListHsmsResponse
extends CloudHsmResponse
implements ToCopyableBuilder<Builder, ListHsmsResponse> {
    private static final SdkField<List<String>> HSM_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListHsmsResponse.getter(ListHsmsResponse::hsmList)).setter(ListHsmsResponse.setter(Builder::hsmList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListHsmsResponse.getter(ListHsmsResponse::nextToken)).setter(ListHsmsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HSM_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> hsmList;
    private final String nextToken;

    private ListHsmsResponse(BuilderImpl builder) {
        super(builder);
        this.hsmList = builder.hsmList;
        this.nextToken = builder.nextToken;
    }

    public boolean hasHsmList() {
        return this.hsmList != null && !(this.hsmList instanceof SdkAutoConstructList);
    }

    public List<String> hsmList() {
        return this.hsmList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHsmsResponse)) {
            return false;
        }
        ListHsmsResponse other = (ListHsmsResponse)((Object)obj);
        return Objects.equals(this.hsmList(), other.hsmList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListHsmsResponse").add("HsmList", this.hsmList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HsmList": {
                return Optional.ofNullable(clazz.cast(this.hsmList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHsmsResponse, T> g) {
        return obj -> g.apply((ListHsmsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudHsmResponse.BuilderImpl
    implements Builder {
        private List<String> hsmList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHsmsResponse model) {
            super(model);
            this.hsmList(model.hsmList);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getHsmList() {
            return this.hsmList;
        }

        @Override
        public final Builder hsmList(Collection<String> hsmList) {
            this.hsmList = HsmListCopier.copy(hsmList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsmList(String ... hsmList) {
            this.hsmList(Arrays.asList(hsmList));
            return this;
        }

        public final void setHsmList(Collection<String> hsmList) {
            this.hsmList = HsmListCopier.copy(hsmList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListHsmsResponse build() {
            return new ListHsmsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudHsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListHsmsResponse> {
        public Builder hsmList(Collection<String> var1);

        public Builder hsmList(String ... var1);

        public Builder nextToken(String var1);
    }
}

