/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConfigRequest extends CloudHsmRequest implements
        ToCopyableBuilder<GetConfigRequest.Builder, GetConfigRequest> {
    private static final SdkField<String> CLIENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetConfigRequest::clientArn)).setter(setter(Builder::clientArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientArn").build()).build();

    private static final SdkField<String> CLIENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetConfigRequest::clientVersionAsString)).setter(setter(Builder::clientVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVersion").build()).build();

    private static final SdkField<List<String>> HAPG_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetConfigRequest::hapgList))
            .setter(setter(Builder::hapgList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HapgList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ARN_FIELD,
            CLIENT_VERSION_FIELD, HAPG_LIST_FIELD));

    private final String clientArn;

    private final String clientVersion;

    private final List<String> hapgList;

    private GetConfigRequest(BuilderImpl builder) {
        super(builder);
        this.clientArn = builder.clientArn;
        this.clientVersion = builder.clientVersion;
        this.hapgList = builder.hapgList;
    }

    /**
     * <p>
     * The ARN of the client.
     * </p>
     * 
     * @return The ARN of the client.
     */
    public String clientArn() {
        return clientArn;
    }

    /**
     * <p>
     * The client version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clientVersion}
     * will return {@link ClientVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clientVersionAsString}.
     * </p>
     * 
     * @return The client version.
     * @see ClientVersion
     */
    public ClientVersion clientVersion() {
        return ClientVersion.fromValue(clientVersion);
    }

    /**
     * <p>
     * The client version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clientVersion}
     * will return {@link ClientVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clientVersionAsString}.
     * </p>
     * 
     * @return The client version.
     * @see ClientVersion
     */
    public String clientVersionAsString() {
        return clientVersion;
    }

    /**
     * Returns true if the HapgList property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasHapgList() {
        return hapgList != null && !(hapgList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of ARNs that identify the high-availability partition groups that are associated with the client.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHapgList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of ARNs that identify the high-availability partition groups that are associated with the client.
     */
    public List<String> hapgList() {
        return hapgList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hapgList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigRequest)) {
            return false;
        }
        GetConfigRequest other = (GetConfigRequest) obj;
        return Objects.equals(clientArn(), other.clientArn())
                && Objects.equals(clientVersionAsString(), other.clientVersionAsString())
                && Objects.equals(hapgList(), other.hapgList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetConfigRequest").add("ClientArn", clientArn()).add("ClientVersion", clientVersionAsString())
                .add("HapgList", hapgList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientArn":
            return Optional.ofNullable(clazz.cast(clientArn()));
        case "ClientVersion":
            return Optional.ofNullable(clazz.cast(clientVersionAsString()));
        case "HapgList":
            return Optional.ofNullable(clazz.cast(hapgList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConfigRequest, T> g) {
        return obj -> g.apply((GetConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetConfigRequest> {
        /**
         * <p>
         * The ARN of the client.
         * </p>
         * 
         * @param clientArn
         *        The ARN of the client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientArn(String clientArn);

        /**
         * <p>
         * The client version.
         * </p>
         * 
         * @param clientVersion
         *        The client version.
         * @see ClientVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientVersion
         */
        Builder clientVersion(String clientVersion);

        /**
         * <p>
         * The client version.
         * </p>
         * 
         * @param clientVersion
         *        The client version.
         * @see ClientVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientVersion
         */
        Builder clientVersion(ClientVersion clientVersion);

        /**
         * <p>
         * A list of ARNs that identify the high-availability partition groups that are associated with the client.
         * </p>
         * 
         * @param hapgList
         *        A list of ARNs that identify the high-availability partition groups that are associated with the
         *        client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hapgList(Collection<String> hapgList);

        /**
         * <p>
         * A list of ARNs that identify the high-availability partition groups that are associated with the client.
         * </p>
         * 
         * @param hapgList
         *        A list of ARNs that identify the high-availability partition groups that are associated with the
         *        client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hapgList(String... hapgList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudHsmRequest.BuilderImpl implements Builder {
        private String clientArn;

        private String clientVersion;

        private List<String> hapgList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigRequest model) {
            super(model);
            clientArn(model.clientArn);
            clientVersion(model.clientVersion);
            hapgList(model.hapgList);
        }

        public final String getClientArn() {
            return clientArn;
        }

        @Override
        public final Builder clientArn(String clientArn) {
            this.clientArn = clientArn;
            return this;
        }

        public final void setClientArn(String clientArn) {
            this.clientArn = clientArn;
        }

        public final String getClientVersion() {
            return clientVersion;
        }

        @Override
        public final Builder clientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
            return this;
        }

        @Override
        public final Builder clientVersion(ClientVersion clientVersion) {
            this.clientVersion(clientVersion == null ? null : clientVersion.toString());
            return this;
        }

        public final void setClientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
        }

        public final Collection<String> getHapgList() {
            return hapgList;
        }

        @Override
        public final Builder hapgList(Collection<String> hapgList) {
            this.hapgList = HapgListCopier.copy(hapgList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hapgList(String... hapgList) {
            hapgList(Arrays.asList(hapgList));
            return this;
        }

        public final void setHapgList(Collection<String> hapgList) {
            this.hapgList = HapgListCopier.copy(hapgList);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetConfigRequest build() {
            return new GetConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
