/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudhsm.model.CloudHSMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateLunaClientRequest
extends CloudHSMRequest
implements ToCopyableBuilder<Builder, CreateLunaClientRequest> {
    private final String label;
    private final String certificate;

    private CreateLunaClientRequest(BuilderImpl builder) {
        super(builder);
        this.label = builder.label;
        this.certificate = builder.certificate;
    }

    public String label() {
        return this.label;
    }

    public String certificate() {
        return this.certificate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLunaClientRequest)) {
            return false;
        }
        CreateLunaClientRequest other = (CreateLunaClientRequest)((Object)obj);
        return Objects.equals(this.label(), other.label()) && Objects.equals(this.certificate(), other.certificate());
    }

    public String toString() {
        return ToString.builder((String)"CreateLunaClientRequest").add("Label", (Object)this.label()).add("Certificate", (Object)this.certificate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Label": {
                return Optional.of(clazz.cast(this.label()));
            }
            case "Certificate": {
                return Optional.of(clazz.cast(this.certificate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudHSMRequest.BuilderImpl
    implements Builder {
        private String label;
        private String certificate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLunaClientRequest model) {
            this.label(model.label);
            this.certificate(model.certificate);
        }

        public final String getLabel() {
            return this.label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final String getCertificate() {
            return this.certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateLunaClientRequest build() {
            return new CreateLunaClientRequest(this);
        }
    }

    public static interface Builder
    extends CloudHSMRequest.Builder,
    CopyableBuilder<Builder, CreateLunaClientRequest> {
        public Builder label(String var1);

        public Builder certificate(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

