/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudhsm.model.GetConfigRequest;

@SdkInternalApi
public class GetConfigRequestModelMarshaller {
    private static final MarshallingInfo<String> CLIENTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientArn").build();
    private static final MarshallingInfo<String> CLIENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientVersion").build();
    private static final MarshallingInfo<List> HAPGLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HapgList").build();
    private static final GetConfigRequestModelMarshaller INSTANCE = new GetConfigRequestModelMarshaller();

    public static GetConfigRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetConfigRequest getConfigRequest, ProtocolMarshaller protocolMarshaller) {
        if (getConfigRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)getConfigRequest.clientArn(), CLIENTARN_BINDING);
            protocolMarshaller.marshall((Object)getConfigRequest.clientVersionString(), CLIENTVERSION_BINDING);
            protocolMarshaller.marshall(getConfigRequest.hapgList(), HAPGLIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

