/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudhsm.model.ClientListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListLunaClientsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListLunaClientsResponse> {
    private final List<String> clientList;
    private final String nextToken;

    private ListLunaClientsResponse(BuilderImpl builder) {
        this.clientList = builder.clientList;
        this.nextToken = builder.nextToken;
    }

    public List<String> clientList() {
        return this.clientList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clientList() == null ? 0 : this.clientList().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLunaClientsResponse)) {
            return false;
        }
        ListLunaClientsResponse other = (ListLunaClientsResponse)((Object)obj);
        if (other.clientList() == null ^ this.clientList() == null) {
            return false;
        }
        if (other.clientList() != null && !other.clientList().equals(this.clientList())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientList() != null) {
            sb.append("ClientList: ").append(this.clientList()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> clientList = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLunaClientsResponse model) {
            this.setClientList(model.clientList);
            this.setNextToken(model.nextToken);
        }

        public final Collection<String> getClientList() {
            return this.clientList;
        }

        @Override
        public final Builder clientList(Collection<String> clientList) {
            this.clientList = ClientListCopier.copy(clientList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientList(String ... clientList) {
            if (this.clientList == null) {
                this.clientList = new SdkInternalList(clientList.length);
            }
            for (String e : clientList) {
                this.clientList.add(e);
            }
            return this;
        }

        public final void setClientList(Collection<String> clientList) {
            this.clientList = ClientListCopier.copy(clientList);
        }

        @SafeVarargs
        public final void setClientList(String ... clientList) {
            if (this.clientList == null) {
                this.clientList = new SdkInternalList(clientList.length);
            }
            for (String e : clientList) {
                this.clientList.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListLunaClientsResponse build() {
            return new ListLunaClientsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListLunaClientsResponse> {
        public Builder clientList(Collection<String> var1);

        public Builder clientList(String ... var1);

        public Builder nextToken(String var1);
    }
}

