/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4aAuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.CloudFrontKeyValueStoreEndpointParams;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.CloudFrontKeyValueStoreEndpointProvider;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal.RuleArn;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal.RuleUrl;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultCloudFrontKeyValueStoreEndpointProvider
implements CloudFrontKeyValueStoreEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(CloudFrontKeyValueStoreEndpointParams params) {
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            Region region = params.region();
            String regionId = region == null ? null : region.id();
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule0(params, regionId);
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(CloudFrontKeyValueStoreEndpointParams params, String region) {
        RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule1(params, region);
        if (result.isResolved()) {
            return result;
        }
        return RuleResult.error("Invalid Configuration: FIPS is not supported with CloudFront-KeyValueStore.");
    }

    private static RuleResult endpointRule1(CloudFrontKeyValueStoreEndpointParams params, String region) {
        if (!params.useFips().booleanValue()) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule2(params, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("KVS ARN must be provided to use this service");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule2(CloudFrontKeyValueStoreEndpointParams params, String region) {
        if (params.kvsArn() != null) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule3(params, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("KVS ARN must be a valid ARN");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(CloudFrontKeyValueStoreEndpointParams params, String region) {
        RuleArn parsedArn = RulesFunctions.awsParseArn(params.kvsArn());
        if (parsedArn != null) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule4(params, parsedArn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Provided ARN is not a valid CloudFront Service ARN. Found: `" + parsedArn.service() + "`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule4(CloudFrontKeyValueStoreEndpointParams params, RuleArn parsedArn, String region) {
        if ("cloudfront".equals(parsedArn.service())) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule5(params, parsedArn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Provided ARN must be a global resource ARN. Found: `" + parsedArn.region() + "`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule5(CloudFrontKeyValueStoreEndpointParams params, RuleArn parsedArn, String region) {
        if ("".equals(parsedArn.region())) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule6(params, parsedArn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("No resource type found in the KVS ARN. Resource type must be `key-value-store`.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(CloudFrontKeyValueStoreEndpointParams params, RuleArn parsedArn, String region) {
        String arnType = RulesFunctions.listAccess(parsedArn.resourceId(), 0);
        if (arnType != null) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule7(params, arnType, parsedArn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("No resource type found in the KVS ARN. Resource type must be `key-value-store`.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule7(CloudFrontKeyValueStoreEndpointParams params, String arnType, RuleArn parsedArn, String region) {
        if (!"".equals(arnType)) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule8(params, arnType, parsedArn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("ARN resource type is invalid. Expected `key-value-store`, found: `" + arnType + "`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(CloudFrontKeyValueStoreEndpointParams params, String arnType, RuleArn parsedArn, String region) {
        if ("key-value-store".equals(arnType)) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule9(params, parsedArn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("CloudFront-KeyValueStore is not supported in partition `" + parsedArn.partition() + "`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(CloudFrontKeyValueStoreEndpointParams params, RuleArn parsedArn, String region) {
        if ("aws".equals(parsedArn.partition())) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule10(params, region, parsedArn);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule19(params, parsedArn);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + parsedArn.accountId() + ".cloudfront-kvs.global.api.aws")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().signingName("cloudfront-keyvaluestore").signingRegionSet(Arrays.asList("*")).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule10(CloudFrontKeyValueStoreEndpointParams params, String region, RuleArn parsedArn) {
        if (region != null) {
            return DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule11(params, region, parsedArn);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule11(CloudFrontKeyValueStoreEndpointParams params, String region, RuleArn parsedArn) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule12(params, partitionResult, parsedArn);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Client was configured for partition `" + partitionResult.name() + "` but Kvs ARN has `" + parsedArn.partition() + "`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule12(CloudFrontKeyValueStoreEndpointParams params, RulePartition partitionResult, RuleArn parsedArn) {
        if (RulesFunctions.stringEquals(partitionResult.name(), parsedArn.partition())) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule13(params, parsedArn);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + parsedArn.accountId() + ".cloudfront-kvs.global.api.aws")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().signingName("cloudfront-keyvaluestore").signingRegionSet(Arrays.asList("*")).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule13(CloudFrontKeyValueStoreEndpointParams params, RuleArn parsedArn) {
        if (params.endpoint() != null) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule14(params, parsedArn);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Provided endpoint is not a valid URL");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule14(CloudFrontKeyValueStoreEndpointParams params, RuleArn parsedArn) {
        RuleUrl url = RulesFunctions.parseURL(params.endpoint());
        if (url != null) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + parsedArn.accountId() + "." + url.authority() + url.path())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().signingName("cloudfront-keyvaluestore").signingRegionSet(Arrays.asList("*")).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule19(CloudFrontKeyValueStoreEndpointParams params, RuleArn parsedArn) {
        if (params.endpoint() != null) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule20(params, parsedArn);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Provided endpoint is not a valid URL");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(CloudFrontKeyValueStoreEndpointParams params, RuleArn parsedArn) {
        RuleUrl url = RulesFunctions.parseURL(params.endpoint());
        if (url != null) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + parsedArn.accountId() + "." + url.authority() + url.path())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().signingName("cloudfront-keyvaluestore").signingRegionSet(Arrays.asList("*")).build())).build());
        }
        return RuleResult.carryOn();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

