/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfrontkeyvaluestore.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.CloudFrontKeyValueStoreRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DeleteKeyRequestListItem;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DeleteKeyRequestsListCopier;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyRequestListItem;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyRequestsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateKeysRequest
extends CloudFrontKeyValueStoreRequest
implements ToCopyableBuilder<Builder, UpdateKeysRequest> {
    private static final SdkField<String> KVS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KvsARN").getter(UpdateKeysRequest.getter(UpdateKeysRequest::kvsARN)).setter(UpdateKeysRequest.setter(Builder::kvsARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("KvsARN").build()}).build();
    private static final SdkField<String> IF_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IfMatch").getter(UpdateKeysRequest.getter(UpdateKeysRequest::ifMatch)).setter(UpdateKeysRequest.setter(Builder::ifMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match").build()}).build();
    private static final SdkField<List<PutKeyRequestListItem>> PUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Puts").getter(UpdateKeysRequest.getter(UpdateKeysRequest::puts)).setter(UpdateKeysRequest.setter(Builder::puts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Puts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PutKeyRequestListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DeleteKeyRequestListItem>> DELETES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Deletes").getter(UpdateKeysRequest.getter(UpdateKeysRequest::deletes)).setter(UpdateKeysRequest.setter(Builder::deletes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deletes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeleteKeyRequestListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KVS_ARN_FIELD, IF_MATCH_FIELD, PUTS_FIELD, DELETES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("KvsARN", KVS_ARN_FIELD);
            this.put("If-Match", IF_MATCH_FIELD);
            this.put("Puts", PUTS_FIELD);
            this.put("Deletes", DELETES_FIELD);
        }
    });
    private final String kvsARN;
    private final String ifMatch;
    private final List<PutKeyRequestListItem> puts;
    private final List<DeleteKeyRequestListItem> deletes;

    private UpdateKeysRequest(BuilderImpl builder) {
        super(builder);
        this.kvsARN = builder.kvsARN;
        this.ifMatch = builder.ifMatch;
        this.puts = builder.puts;
        this.deletes = builder.deletes;
    }

    public final String kvsARN() {
        return this.kvsARN;
    }

    public final String ifMatch() {
        return this.ifMatch;
    }

    public final boolean hasPuts() {
        return this.puts != null && !(this.puts instanceof SdkAutoConstructList);
    }

    public final List<PutKeyRequestListItem> puts() {
        return this.puts;
    }

    public final boolean hasDeletes() {
        return this.deletes != null && !(this.deletes instanceof SdkAutoConstructList);
    }

    public final List<DeleteKeyRequestListItem> deletes() {
        return this.deletes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.kvsARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.ifMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPuts() ? this.puts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeletes() ? this.deletes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKeysRequest)) {
            return false;
        }
        UpdateKeysRequest other = (UpdateKeysRequest)((Object)obj);
        return Objects.equals(this.kvsARN(), other.kvsARN()) && Objects.equals(this.ifMatch(), other.ifMatch()) && this.hasPuts() == other.hasPuts() && Objects.equals(this.puts(), other.puts()) && this.hasDeletes() == other.hasDeletes() && Objects.equals(this.deletes(), other.deletes());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateKeysRequest").add("KvsARN", (Object)this.kvsARN()).add("IfMatch", (Object)this.ifMatch()).add("Puts", this.hasPuts() ? this.puts() : null).add("Deletes", this.hasDeletes() ? this.deletes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KvsARN": {
                return Optional.ofNullable(clazz.cast(this.kvsARN()));
            }
            case "IfMatch": {
                return Optional.ofNullable(clazz.cast(this.ifMatch()));
            }
            case "Puts": {
                return Optional.ofNullable(clazz.cast(this.puts()));
            }
            case "Deletes": {
                return Optional.ofNullable(clazz.cast(this.deletes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateKeysRequest, T> g) {
        return obj -> g.apply((UpdateKeysRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontKeyValueStoreRequest.BuilderImpl
    implements Builder {
        private String kvsARN;
        private String ifMatch;
        private List<PutKeyRequestListItem> puts = DefaultSdkAutoConstructList.getInstance();
        private List<DeleteKeyRequestListItem> deletes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKeysRequest model) {
            super(model);
            this.kvsARN(model.kvsARN);
            this.ifMatch(model.ifMatch);
            this.puts(model.puts);
            this.deletes(model.deletes);
        }

        public final String getKvsARN() {
            return this.kvsARN;
        }

        public final void setKvsARN(String kvsARN) {
            this.kvsARN = kvsARN;
        }

        @Override
        public final Builder kvsARN(String kvsARN) {
            this.kvsARN = kvsARN;
            return this;
        }

        public final String getIfMatch() {
            return this.ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final List<PutKeyRequestListItem.Builder> getPuts() {
            List<PutKeyRequestListItem.Builder> result = PutKeyRequestsListCopier.copyToBuilder(this.puts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPuts(Collection<PutKeyRequestListItem.BuilderImpl> puts) {
            this.puts = PutKeyRequestsListCopier.copyFromBuilder(puts);
        }

        @Override
        public final Builder puts(Collection<PutKeyRequestListItem> puts) {
            this.puts = PutKeyRequestsListCopier.copy(puts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder puts(PutKeyRequestListItem ... puts) {
            this.puts(Arrays.asList(puts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder puts(Consumer<PutKeyRequestListItem.Builder> ... puts) {
            this.puts(Stream.of(puts).map(c -> (PutKeyRequestListItem)((PutKeyRequestListItem.Builder)PutKeyRequestListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DeleteKeyRequestListItem.Builder> getDeletes() {
            List<DeleteKeyRequestListItem.Builder> result = DeleteKeyRequestsListCopier.copyToBuilder(this.deletes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeletes(Collection<DeleteKeyRequestListItem.BuilderImpl> deletes) {
            this.deletes = DeleteKeyRequestsListCopier.copyFromBuilder(deletes);
        }

        @Override
        public final Builder deletes(Collection<DeleteKeyRequestListItem> deletes) {
            this.deletes = DeleteKeyRequestsListCopier.copy(deletes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletes(DeleteKeyRequestListItem ... deletes) {
            this.deletes(Arrays.asList(deletes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletes(Consumer<DeleteKeyRequestListItem.Builder> ... deletes) {
            this.deletes(Stream.of(deletes).map(c -> (DeleteKeyRequestListItem)((DeleteKeyRequestListItem.Builder)DeleteKeyRequestListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateKeysRequest build() {
            return new UpdateKeysRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontKeyValueStoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateKeysRequest> {
        public Builder kvsARN(String var1);

        public Builder ifMatch(String var1);

        public Builder puts(Collection<PutKeyRequestListItem> var1);

        public Builder puts(PutKeyRequestListItem ... var1);

        public Builder puts(Consumer<PutKeyRequestListItem.Builder> ... var1);

        public Builder deletes(Collection<DeleteKeyRequestListItem> var1);

        public Builder deletes(DeleteKeyRequestListItem ... var1);

        public Builder deletes(Consumer<DeleteKeyRequestListItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

