/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.CloudFrontKeyValueStoreEndpointParams;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.CloudFrontKeyValueStoreEndpointProvider;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal.Condition;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal.DefaultEndpointAuthSchemeStrategyFactory;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal.DefaultRuleEngine;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal.EndpointAuthSchemeStrategy;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal.EndpointResult;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal.EndpointRuleset;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal.Expr;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal.FnNode;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal.Identifier;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal.Literal;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal.Parameter;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal.ParameterType;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal.Parameters;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal.Rule;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal.Value;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.MapUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultCloudFrontKeyValueStoreEndpointProvider
implements CloudFrontKeyValueStoreEndpointProvider {
    private static final Logger LOG = Logger.loggerFor(DefaultCloudFrontKeyValueStoreEndpointProvider.class);
    private static final EndpointRuleset ENDPOINT_RULE_SET = DefaultCloudFrontKeyValueStoreEndpointProvider.ruleSet();
    private final EndpointAuthSchemeStrategy endpointAuthSchemeStrategy;

    public DefaultCloudFrontKeyValueStoreEndpointProvider() {
        DefaultEndpointAuthSchemeStrategyFactory endpointAuthSchemeStrategyFactory = new DefaultEndpointAuthSchemeStrategyFactory();
        this.endpointAuthSchemeStrategy = endpointAuthSchemeStrategyFactory.endpointAuthSchemeStrategy();
    }

    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(CloudFrontKeyValueStoreEndpointParams endpointParams) {
        Validate.notNull((Object)endpointParams.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        Value res = new DefaultRuleEngine().evaluate(ENDPOINT_RULE_SET, DefaultCloudFrontKeyValueStoreEndpointProvider.toIdentifierValueMap(endpointParams));
        try {
            return CompletableFuture.completedFuture(this.valueAsEndpointOrThrow(res));
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static Map<Identifier, Value> toIdentifierValueMap(CloudFrontKeyValueStoreEndpointParams params) {
        HashMap<Identifier, Value> paramsMap = new HashMap<Identifier, Value>();
        if (params.kvsArn() != null) {
            paramsMap.put(Identifier.of("KvsARN"), Value.fromStr(params.kvsArn()));
        }
        if (params.region() != null) {
            paramsMap.put(Identifier.of("Region"), Value.fromStr(params.region().id()));
        }
        if (params.useFips() != null) {
            paramsMap.put(Identifier.of("UseFIPS"), Value.fromBool(params.useFips()));
        }
        if (params.endpoint() != null) {
            paramsMap.put(Identifier.of("Endpoint"), Value.fromStr(params.endpoint()));
        }
        return paramsMap;
    }

    Endpoint valueAsEndpointOrThrow(Value value) {
        if (value instanceof Value.Endpoint) {
            Value.Endpoint endpoint = value.expectEndpoint();
            Endpoint.Builder builder = Endpoint.builder();
            builder.url(URI.create(endpoint.getUrl()));
            Map<String, List<String>> headers = endpoint.getHeaders();
            if (headers != null) {
                headers.forEach((name, values) -> values.forEach(v -> builder.putHeader(name, v)));
            }
            this.addKnownProperties(builder, endpoint.getProperties());
            return builder.build();
        }
        if (value instanceof Value.Str) {
            String errorMsg = value.expectString();
            if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
            }
            throw SdkClientException.create((String)errorMsg);
        }
        throw SdkClientException.create((String)("Rule engine return neither an endpoint result or error value. Returned value was: " + value));
    }

    private static Rule endpointRule_14() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{parsedArn#accountId}.{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4a"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("cloudfront-keyvaluestore"), (Object)Identifier.of("signingRegionSet"), (Object)Literal.fromTuple(Arrays.asList(Literal.fromStr("*")))))))).build());
    }

    private static Rule endpointRule_13() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).treeRule(Arrays.asList(DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_14()));
    }

    private static Rule endpointRule_15() {
        return Rule.builder().error("Provided endpoint is not a valid URL");
    }

    private static Rule endpointRule_12() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_13(), DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_15()));
    }

    private static Rule endpointRule_16() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://{parsedArn#accountId}.cloudfront-kvs.global.api.aws")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4a"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("cloudfront-keyvaluestore"), (Object)Identifier.of("signingRegionSet"), (Object)Literal.fromTuple(Arrays.asList(Literal.fromStr("*")))))))).build());
    }

    private static Rule endpointRule_11() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("partitionResult")), Expr.of("name"))).build().validate(), Expr.of("{parsedArn#partition}"))).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_12(), DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_16()));
    }

    private static Rule endpointRule_17() {
        return Rule.builder().error("Client was configured for partition `{partitionResult#name}` but Kvs ARN has `{parsedArn#partition}`");
    }

    private static Rule endpointRule_10() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("partitionResult").build()).treeRule(Arrays.asList(DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_11(), DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_17()));
    }

    private static Rule endpointRule_9() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_10()));
    }

    private static Rule endpointRule_20() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{parsedArn#accountId}.{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4a"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("cloudfront-keyvaluestore"), (Object)Identifier.of("signingRegionSet"), (Object)Literal.fromTuple(Arrays.asList(Literal.fromStr("*")))))))).build());
    }

    private static Rule endpointRule_19() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).treeRule(Arrays.asList(DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_20()));
    }

    private static Rule endpointRule_21() {
        return Rule.builder().error("Provided endpoint is not a valid URL");
    }

    private static Rule endpointRule_18() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_19(), DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_21()));
    }

    private static Rule endpointRule_22() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://{parsedArn#accountId}.cloudfront-kvs.global.api.aws")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4a"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("cloudfront-keyvaluestore"), (Object)Identifier.of("signingRegionSet"), (Object)Literal.fromTuple(Arrays.asList(Literal.fromStr("*")))))))).build());
    }

    private static Rule endpointRule_8() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("parsedArn")), Expr.of("partition"))).build().validate(), Expr.of("aws"))).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_9(), DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_18(), DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_22()));
    }

    private static Rule endpointRule_23() {
        return Rule.builder().error("CloudFront-KeyValueStore is not supported in partition `{parsedArn#partition}`");
    }

    private static Rule endpointRule_7() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("arnType")), Expr.of("key-value-store"))).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_8(), DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_23()));
    }

    private static Rule endpointRule_24() {
        return Rule.builder().error("ARN resource type is invalid. Expected `key-value-store`, found: `{arnType}`");
    }

    private static Rule endpointRule_6() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("arnType")), Expr.of(""))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_7(), DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_24()));
    }

    private static Rule endpointRule_25() {
        return Rule.builder().error("No resource type found in the KVS ARN. Resource type must be `key-value-store`.");
    }

    private static Rule endpointRule_5() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("parsedArn")), Expr.of("resourceId[0]"))).build().validate()).result("arnType").build()).treeRule(Arrays.asList(DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_6(), DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_25()));
    }

    private static Rule endpointRule_26() {
        return Rule.builder().error("No resource type found in the KVS ARN. Resource type must be `key-value-store`.");
    }

    private static Rule endpointRule_4() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("parsedArn")), Expr.of("region"))).build().validate(), Expr.of(""))).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_5(), DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_26()));
    }

    private static Rule endpointRule_27() {
        return Rule.builder().error("Provided ARN must be a global resource ARN. Found: `{parsedArn#region}`");
    }

    private static Rule endpointRule_3() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("parsedArn")), Expr.of("service"))).build().validate(), Expr.of("cloudfront"))).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_4(), DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_27()));
    }

    private static Rule endpointRule_28() {
        return Rule.builder().error("Provided ARN is not a valid CloudFront Service ARN. Found: `{parsedArn#service}`");
    }

    private static Rule endpointRule_2() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.parseArn").argv(Arrays.asList(Expr.ref(Identifier.of("KvsARN")))).build().validate()).result("parsedArn").build()).treeRule(Arrays.asList(DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_3(), DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_28()));
    }

    private static Rule endpointRule_29() {
        return Rule.builder().error("KVS ARN must be a valid ARN");
    }

    private static Rule endpointRule_1() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("KvsARN")))).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_2(), DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_29()));
    }

    private static Rule endpointRule_30() {
        return Rule.builder().error("KVS ARN must be provided to use this service");
    }

    private static Rule endpointRule_0() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).treeRule(Arrays.asList(DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_1(), DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_30()));
    }

    private static Rule endpointRule_31() {
        return Rule.builder().error("Invalid Configuration: FIPS is not supported with CloudFront-KeyValueStore.");
    }

    private static EndpointRuleset ruleSet() {
        return EndpointRuleset.builder().version("1.0").serviceId(null).parameters(Parameters.builder().addParameter(Parameter.builder().name("KvsARN").type(ParameterType.fromValue("String")).required(false).documentation("The ARN of the Key Value Store").build()).addParameter(Parameter.builder().name("Region").type(ParameterType.fromValue("String")).required(false).builtIn("AWS::Region").documentation("The AWS region used to dispatch the request.").build()).addParameter(Parameter.builder().name("UseFIPS").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseFIPS").documentation("When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("Endpoint").type(ParameterType.fromValue("String")).required(false).builtIn("SDK::Endpoint").documentation("Override the endpoint used to send this request").build()).build()).addRule(DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_0()).addRule(DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule_31()).build();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private void addKnownProperties(Endpoint.Builder builder, Map<String, Value> properties) {
        properties.forEach((n, v) -> {
            switch (n) {
                case "authSchemes": {
                    builder.putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, this.endpointAuthSchemeStrategy.createAuthSchemes((Value)v));
                    break;
                }
                default: {
                    LOG.debug(() -> "Ignoring unknown endpoint property: " + n);
                }
            }
        });
    }
}

