/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum CertificateSource {
    CLOUDFRONT("cloudfront"),
    IAM("iam"),
    ACM("acm"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private CertificateSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CertificateSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(CertificateSource.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CertificateSource> knownValues() {
        return Stream.of(CertificateSource.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

