/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFieldLevelEncryptionProfileConfigResponse extends CloudFrontResponse implements
        ToCopyableBuilder<GetFieldLevelEncryptionProfileConfigResponse.Builder, GetFieldLevelEncryptionProfileConfigResponse> {
    private static final SdkField<FieldLevelEncryptionProfileConfig> FIELD_LEVEL_ENCRYPTION_PROFILE_CONFIG_FIELD = SdkField
            .<FieldLevelEncryptionProfileConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetFieldLevelEncryptionProfileConfigResponse::fieldLevelEncryptionProfileConfig))
            .setter(setter(Builder::fieldLevelEncryptionProfileConfig))
            .constructor(FieldLevelEncryptionProfileConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldLevelEncryptionProfileConfig")
                    .unmarshallLocationName("FieldLevelEncryptionProfileConfig").build(), PayloadTrait.create()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetFieldLevelEncryptionProfileConfigResponse::eTag))
            .setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FIELD_LEVEL_ENCRYPTION_PROFILE_CONFIG_FIELD, E_TAG_FIELD));

    private final FieldLevelEncryptionProfileConfig fieldLevelEncryptionProfileConfig;

    private final String eTag;

    private GetFieldLevelEncryptionProfileConfigResponse(BuilderImpl builder) {
        super(builder);
        this.fieldLevelEncryptionProfileConfig = builder.fieldLevelEncryptionProfileConfig;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * Return the field-level encryption profile configuration information.
     * </p>
     * 
     * @return Return the field-level encryption profile configuration information.
     */
    public FieldLevelEncryptionProfileConfig fieldLevelEncryptionProfileConfig() {
        return fieldLevelEncryptionProfileConfig;
    }

    /**
     * <p>
     * The current version of the field-level encryption profile configuration result. For example:
     * <code>E2QWRUHAPOMQZL</code>.
     * </p>
     * 
     * @return The current version of the field-level encryption profile configuration result. For example:
     *         <code>E2QWRUHAPOMQZL</code>.
     */
    public String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldLevelEncryptionProfileConfig());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFieldLevelEncryptionProfileConfigResponse)) {
            return false;
        }
        GetFieldLevelEncryptionProfileConfigResponse other = (GetFieldLevelEncryptionProfileConfigResponse) obj;
        return Objects.equals(fieldLevelEncryptionProfileConfig(), other.fieldLevelEncryptionProfileConfig())
                && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetFieldLevelEncryptionProfileConfigResponse")
                .add("FieldLevelEncryptionProfileConfig", fieldLevelEncryptionProfileConfig()).add("ETag", eTag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldLevelEncryptionProfileConfig":
            return Optional.ofNullable(clazz.cast(fieldLevelEncryptionProfileConfig()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFieldLevelEncryptionProfileConfigResponse, T> g) {
        return obj -> g.apply((GetFieldLevelEncryptionProfileConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetFieldLevelEncryptionProfileConfigResponse> {
        /**
         * <p>
         * Return the field-level encryption profile configuration information.
         * </p>
         * 
         * @param fieldLevelEncryptionProfileConfig
         *        Return the field-level encryption profile configuration information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldLevelEncryptionProfileConfig(FieldLevelEncryptionProfileConfig fieldLevelEncryptionProfileConfig);

        /**
         * <p>
         * Return the field-level encryption profile configuration information.
         * </p>
         * This is a convenience that creates an instance of the {@link FieldLevelEncryptionProfileConfig.Builder}
         * avoiding the need to create one manually via {@link FieldLevelEncryptionProfileConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link FieldLevelEncryptionProfileConfig.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #fieldLevelEncryptionProfileConfig(FieldLevelEncryptionProfileConfig)}.
         * 
         * @param fieldLevelEncryptionProfileConfig
         *        a consumer that will call methods on {@link FieldLevelEncryptionProfileConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldLevelEncryptionProfileConfig(FieldLevelEncryptionProfileConfig)
         */
        default Builder fieldLevelEncryptionProfileConfig(
                Consumer<FieldLevelEncryptionProfileConfig.Builder> fieldLevelEncryptionProfileConfig) {
            return fieldLevelEncryptionProfileConfig(FieldLevelEncryptionProfileConfig.builder()
                    .applyMutation(fieldLevelEncryptionProfileConfig).build());
        }

        /**
         * <p>
         * The current version of the field-level encryption profile configuration result. For example:
         * <code>E2QWRUHAPOMQZL</code>.
         * </p>
         * 
         * @param eTag
         *        The current version of the field-level encryption profile configuration result. For example:
         *        <code>E2QWRUHAPOMQZL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private FieldLevelEncryptionProfileConfig fieldLevelEncryptionProfileConfig;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFieldLevelEncryptionProfileConfigResponse model) {
            super(model);
            fieldLevelEncryptionProfileConfig(model.fieldLevelEncryptionProfileConfig);
            eTag(model.eTag);
        }

        public final FieldLevelEncryptionProfileConfig.Builder getFieldLevelEncryptionProfileConfig() {
            return fieldLevelEncryptionProfileConfig != null ? fieldLevelEncryptionProfileConfig.toBuilder() : null;
        }

        @Override
        public final Builder fieldLevelEncryptionProfileConfig(FieldLevelEncryptionProfileConfig fieldLevelEncryptionProfileConfig) {
            this.fieldLevelEncryptionProfileConfig = fieldLevelEncryptionProfileConfig;
            return this;
        }

        public final void setFieldLevelEncryptionProfileConfig(
                FieldLevelEncryptionProfileConfig.BuilderImpl fieldLevelEncryptionProfileConfig) {
            this.fieldLevelEncryptionProfileConfig = fieldLevelEncryptionProfileConfig != null ? fieldLevelEncryptionProfileConfig
                    .build() : null;
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public GetFieldLevelEncryptionProfileConfigResponse build() {
            return new GetFieldLevelEncryptionProfileConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
