/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that describes the default cache behavior if you don't specify a <code>CacheBehavior</code> element or
 * if files don't match any of the values of <code>PathPattern</code> in <code>CacheBehavior</code> elements. You must
 * create exactly one default cache behavior.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultCacheBehavior implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultCacheBehavior.Builder, DefaultCacheBehavior> {
    private static final SdkField<String> TARGET_ORIGIN_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DefaultCacheBehavior::targetOriginId))
            .setter(setter(Builder::targetOriginId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetOriginId")
                    .unmarshallLocationName("TargetOriginId").build()).build();

    private static final SdkField<ForwardedValues> FORWARDED_VALUES_FIELD = SdkField
            .<ForwardedValues> builder(MarshallingType.SDK_POJO)
            .getter(getter(DefaultCacheBehavior::forwardedValues))
            .setter(setter(Builder::forwardedValues))
            .constructor(ForwardedValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardedValues")
                    .unmarshallLocationName("ForwardedValues").build()).build();

    private static final SdkField<TrustedSigners> TRUSTED_SIGNERS_FIELD = SdkField
            .<TrustedSigners> builder(MarshallingType.SDK_POJO)
            .getter(getter(DefaultCacheBehavior::trustedSigners))
            .setter(setter(Builder::trustedSigners))
            .constructor(TrustedSigners::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedSigners")
                    .unmarshallLocationName("TrustedSigners").build()).build();

    private static final SdkField<String> VIEWER_PROTOCOL_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DefaultCacheBehavior::viewerProtocolPolicyAsString))
            .setter(setter(Builder::viewerProtocolPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewerProtocolPolicy")
                    .unmarshallLocationName("ViewerProtocolPolicy").build()).build();

    private static final SdkField<Long> MIN_TTL_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(DefaultCacheBehavior::minTTL))
            .setter(setter(Builder::minTTL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinTTL")
                    .unmarshallLocationName("MinTTL").build()).build();

    private static final SdkField<AllowedMethods> ALLOWED_METHODS_FIELD = SdkField
            .<AllowedMethods> builder(MarshallingType.SDK_POJO)
            .getter(getter(DefaultCacheBehavior::allowedMethods))
            .setter(setter(Builder::allowedMethods))
            .constructor(AllowedMethods::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedMethods")
                    .unmarshallLocationName("AllowedMethods").build()).build();

    private static final SdkField<Boolean> SMOOTH_STREAMING_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DefaultCacheBehavior::smoothStreaming))
            .setter(setter(Builder::smoothStreaming))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmoothStreaming")
                    .unmarshallLocationName("SmoothStreaming").build()).build();

    private static final SdkField<Long> DEFAULT_TTL_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(DefaultCacheBehavior::defaultTTL))
            .setter(setter(Builder::defaultTTL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultTTL")
                    .unmarshallLocationName("DefaultTTL").build()).build();

    private static final SdkField<Long> MAX_TTL_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(DefaultCacheBehavior::maxTTL))
            .setter(setter(Builder::maxTTL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxTTL")
                    .unmarshallLocationName("MaxTTL").build()).build();

    private static final SdkField<Boolean> COMPRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DefaultCacheBehavior::compress))
            .setter(setter(Builder::compress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compress")
                    .unmarshallLocationName("Compress").build()).build();

    private static final SdkField<LambdaFunctionAssociations> LAMBDA_FUNCTION_ASSOCIATIONS_FIELD = SdkField
            .<LambdaFunctionAssociations> builder(MarshallingType.SDK_POJO)
            .getter(getter(DefaultCacheBehavior::lambdaFunctionAssociations))
            .setter(setter(Builder::lambdaFunctionAssociations))
            .constructor(LambdaFunctionAssociations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaFunctionAssociations")
                    .unmarshallLocationName("LambdaFunctionAssociations").build()).build();

    private static final SdkField<String> FIELD_LEVEL_ENCRYPTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DefaultCacheBehavior::fieldLevelEncryptionId))
            .setter(setter(Builder::fieldLevelEncryptionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldLevelEncryptionId")
                    .unmarshallLocationName("FieldLevelEncryptionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ORIGIN_ID_FIELD,
            FORWARDED_VALUES_FIELD, TRUSTED_SIGNERS_FIELD, VIEWER_PROTOCOL_POLICY_FIELD, MIN_TTL_FIELD, ALLOWED_METHODS_FIELD,
            SMOOTH_STREAMING_FIELD, DEFAULT_TTL_FIELD, MAX_TTL_FIELD, COMPRESS_FIELD, LAMBDA_FUNCTION_ASSOCIATIONS_FIELD,
            FIELD_LEVEL_ENCRYPTION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String targetOriginId;

    private final ForwardedValues forwardedValues;

    private final TrustedSigners trustedSigners;

    private final String viewerProtocolPolicy;

    private final Long minTTL;

    private final AllowedMethods allowedMethods;

    private final Boolean smoothStreaming;

    private final Long defaultTTL;

    private final Long maxTTL;

    private final Boolean compress;

    private final LambdaFunctionAssociations lambdaFunctionAssociations;

    private final String fieldLevelEncryptionId;

    private DefaultCacheBehavior(BuilderImpl builder) {
        this.targetOriginId = builder.targetOriginId;
        this.forwardedValues = builder.forwardedValues;
        this.trustedSigners = builder.trustedSigners;
        this.viewerProtocolPolicy = builder.viewerProtocolPolicy;
        this.minTTL = builder.minTTL;
        this.allowedMethods = builder.allowedMethods;
        this.smoothStreaming = builder.smoothStreaming;
        this.defaultTTL = builder.defaultTTL;
        this.maxTTL = builder.maxTTL;
        this.compress = builder.compress;
        this.lambdaFunctionAssociations = builder.lambdaFunctionAssociations;
        this.fieldLevelEncryptionId = builder.fieldLevelEncryptionId;
    }

    /**
     * <p>
     * The value of <code>ID</code> for the origin that you want CloudFront to route requests to when a request matches
     * the path pattern either for a cache behavior or for the default cache behavior in your distribution.
     * </p>
     * 
     * @return The value of <code>ID</code> for the origin that you want CloudFront to route requests to when a request
     *         matches the path pattern either for a cache behavior or for the default cache behavior in your
     *         distribution.
     */
    public String targetOriginId() {
        return targetOriginId;
    }

    /**
     * <p>
     * A complex type that specifies how CloudFront handles query strings and cookies.
     * </p>
     * 
     * @return A complex type that specifies how CloudFront handles query strings and cookies.
     */
    public ForwardedValues forwardedValues() {
        return forwardedValues;
    }

    /**
     * <p>
     * A complex type that specifies the AWS accounts, if any, that you want to allow to create signed URLs for private
     * content.
     * </p>
     * <p>
     * If you want to require signed URLs in requests for objects in the target origin that match the
     * <code>PathPattern</code> for this cache behavior, specify <code>true</code> for <code>Enabled</code>, and specify
     * the applicable values for <code>Quantity</code> and <code>Items</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
     * Content through CloudFront</a> in the <i> Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * If you don't want to require signed URLs in requests for objects that match <code>PathPattern</code>, specify
     * <code>false</code> for <code>Enabled</code> and <code>0</code> for <code>Quantity</code>. Omit <code>Items</code>
     * .
     * </p>
     * <p>
     * To add, change, or remove one or more trusted signers, change <code>Enabled</code> to <code>true</code> (if it's
     * currently <code>false</code>), change <code>Quantity</code> as applicable, and specify all of the trusted signers
     * that you want to include in the updated distribution.
     * </p>
     * 
     * @return A complex type that specifies the AWS accounts, if any, that you want to allow to create signed URLs for
     *         private content.</p>
     *         <p>
     *         If you want to require signed URLs in requests for objects in the target origin that match the
     *         <code>PathPattern</code> for this cache behavior, specify <code>true</code> for <code>Enabled</code>, and
     *         specify the applicable values for <code>Quantity</code> and <code>Items</code>. For more information, see
     *         <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
     *         Private Content through CloudFront</a> in the <i> Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <p>
     *         If you don't want to require signed URLs in requests for objects that match <code>PathPattern</code>,
     *         specify <code>false</code> for <code>Enabled</code> and <code>0</code> for <code>Quantity</code>. Omit
     *         <code>Items</code>.
     *         </p>
     *         <p>
     *         To add, change, or remove one or more trusted signers, change <code>Enabled</code> to <code>true</code>
     *         (if it's currently <code>false</code>), change <code>Quantity</code> as applicable, and specify all of
     *         the trusted signers that you want to include in the updated distribution.
     */
    public TrustedSigners trustedSigners() {
        return trustedSigners;
    }

    /**
     * <p>
     * The protocol that viewers can use to access the files in the origin specified by <code>TargetOriginId</code> when
     * a request matches the path pattern in <code>PathPattern</code>. You can specify the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>allow-all</code>: Viewers can use HTTP or HTTPS.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns an HTTP status code of
     * 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the
     * new URL.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403
     * (Forbidden).
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about requiring the HTTPS protocol, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html">Using an HTTPS
     * Connection to Access Your Objects</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never
     * to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that
     * you clear your objects' cache because cached objects are protocol agnostic. That means that an edge location will
     * return an object from the cache regardless of whether the current request protocol matches the protocol used
     * previously. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long
     * Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #viewerProtocolPolicy} will return {@link ViewerProtocolPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #viewerProtocolPolicyAsString}.
     * </p>
     * 
     * @return The protocol that viewers can use to access the files in the origin specified by
     *         <code>TargetOriginId</code> when a request matches the path pattern in <code>PathPattern</code>. You can
     *         specify the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>allow-all</code>: Viewers can use HTTP or HTTPS.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns an HTTP status
     *         code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the
     *         request using the new URL.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403
     *         (Forbidden).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about requiring the HTTPS protocol, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html">Using an
     *         HTTPS Connection to Access Your Objects</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is
     *         never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we
     *         recommend that you clear your objects' cache because cached objects are protocol agnostic. That means
     *         that an edge location will return an object from the cache regardless of whether the current request
     *         protocol matches the protocol used previously. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How
     *         Long Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     * @see ViewerProtocolPolicy
     */
    public ViewerProtocolPolicy viewerProtocolPolicy() {
        return ViewerProtocolPolicy.fromValue(viewerProtocolPolicy);
    }

    /**
     * <p>
     * The protocol that viewers can use to access the files in the origin specified by <code>TargetOriginId</code> when
     * a request matches the path pattern in <code>PathPattern</code>. You can specify the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>allow-all</code>: Viewers can use HTTP or HTTPS.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns an HTTP status code of
     * 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the
     * new URL.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403
     * (Forbidden).
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about requiring the HTTPS protocol, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html">Using an HTTPS
     * Connection to Access Your Objects</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never
     * to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that
     * you clear your objects' cache because cached objects are protocol agnostic. That means that an edge location will
     * return an object from the cache regardless of whether the current request protocol matches the protocol used
     * previously. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long
     * Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #viewerProtocolPolicy} will return {@link ViewerProtocolPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #viewerProtocolPolicyAsString}.
     * </p>
     * 
     * @return The protocol that viewers can use to access the files in the origin specified by
     *         <code>TargetOriginId</code> when a request matches the path pattern in <code>PathPattern</code>. You can
     *         specify the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>allow-all</code>: Viewers can use HTTP or HTTPS.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns an HTTP status
     *         code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the
     *         request using the new URL.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403
     *         (Forbidden).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about requiring the HTTPS protocol, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html">Using an
     *         HTTPS Connection to Access Your Objects</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is
     *         never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we
     *         recommend that you clear your objects' cache because cached objects are protocol agnostic. That means
     *         that an edge location will return an object from the cache regardless of whether the current request
     *         protocol matches the protocol used previously. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How
     *         Long Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     * @see ViewerProtocolPolicy
     */
    public String viewerProtocolPolicyAsString() {
        return viewerProtocolPolicy;
    }

    /**
     * <p>
     * The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another
     * request to your origin to determine whether the object has been updated. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long
     * Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to forward all headers to
     * your origin (under <code>Headers</code>, if you specify <code>1</code> for <code>Quantity</code> and
     * <code>*</code> for <code>Name</code>).
     * </p>
     * 
     * @return The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards
     *         another request to your origin to determine whether the object has been updated. For more information,
     *         see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing
     *         How Long Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer
     *         Guide</i>.</p>
     *         <p>
     *         You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to forward all
     *         headers to your origin (under <code>Headers</code>, if you specify <code>1</code> for
     *         <code>Quantity</code> and <code>*</code> for <code>Name</code>).
     */
    public Long minTTL() {
        return minTTL;
    }

    /**
     * Returns the value of the AllowedMethods property for this object.
     * 
     * @return The value of the AllowedMethods property for this object.
     */
    public AllowedMethods allowedMethods() {
        return allowedMethods;
    }

    /**
     * <p>
     * Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin
     * that is associated with this cache behavior. If so, specify <code>true</code>; if not, specify <code>false</code>
     * . If you specify <code>true</code> for <code>SmoothStreaming</code>, you can still distribute other content using
     * this cache behavior if the content matches the value of <code>PathPattern</code>.
     * </p>
     * 
     * @return Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the
     *         origin that is associated with this cache behavior. If so, specify <code>true</code>; if not, specify
     *         <code>false</code>. If you specify <code>true</code> for <code>SmoothStreaming</code>, you can still
     *         distribute other content using this cache behavior if the content matches the value of
     *         <code>PathPattern</code>.
     */
    public Boolean smoothStreaming() {
        return smoothStreaming;
    }

    /**
     * <p>
     * The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another
     * request to your origin to determine whether the object has been updated. The value that you specify applies only
     * when your origin does not add HTTP headers such as <code>Cache-Control max-age</code>,
     * <code>Cache-Control s-maxage</code>, and <code>Expires</code> to objects. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long
     * Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards
     *         another request to your origin to determine whether the object has been updated. The value that you
     *         specify applies only when your origin does not add HTTP headers such as
     *         <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and <code>Expires</code> to
     *         objects. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How
     *         Long Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public Long defaultTTL() {
        return defaultTTL;
    }

    /**
     * <p>
     * The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another
     * request to your origin to determine whether the object has been updated. The value that you specify applies only
     * when your origin adds HTTP headers such as <code>Cache-Control max-age</code>,
     * <code>Cache-Control s-maxage</code>, and <code>Expires</code> to objects. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long
     * Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards
     *         another request to your origin to determine whether the object has been updated. The value that you
     *         specify applies only when your origin adds HTTP headers such as <code>Cache-Control max-age</code>,
     *         <code>Cache-Control s-maxage</code>, and <code>Expires</code> to objects. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How
     *         Long Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public Long maxTTL() {
        return maxTTL;
    }

    /**
     * <p>
     * Whether you want CloudFront to automatically compress certain files for this cache behavior. If so, specify
     * <code>true</code>; if not, specify <code>false</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html">Serving
     * Compressed Files</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return Whether you want CloudFront to automatically compress certain files for this cache behavior. If so,
     *         specify <code>true</code>; if not, specify <code>false</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html"
     *         >Serving Compressed Files</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public Boolean compress() {
        return compress;
    }

    /**
     * <p>
     * A complex type that contains zero or more Lambda function associations for a cache behavior.
     * </p>
     * 
     * @return A complex type that contains zero or more Lambda function associations for a cache behavior.
     */
    public LambdaFunctionAssociations lambdaFunctionAssociations() {
        return lambdaFunctionAssociations;
    }

    /**
     * <p>
     * The value of <code>ID</code> for the field-level encryption configuration that you want CloudFront to use for
     * encrypting specific fields of data for a cache behavior or for the default cache behavior in your distribution.
     * </p>
     * 
     * @return The value of <code>ID</code> for the field-level encryption configuration that you want CloudFront to use
     *         for encrypting specific fields of data for a cache behavior or for the default cache behavior in your
     *         distribution.
     */
    public String fieldLevelEncryptionId() {
        return fieldLevelEncryptionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetOriginId());
        hashCode = 31 * hashCode + Objects.hashCode(forwardedValues());
        hashCode = 31 * hashCode + Objects.hashCode(trustedSigners());
        hashCode = 31 * hashCode + Objects.hashCode(viewerProtocolPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(minTTL());
        hashCode = 31 * hashCode + Objects.hashCode(allowedMethods());
        hashCode = 31 * hashCode + Objects.hashCode(smoothStreaming());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTTL());
        hashCode = 31 * hashCode + Objects.hashCode(maxTTL());
        hashCode = 31 * hashCode + Objects.hashCode(compress());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(fieldLevelEncryptionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultCacheBehavior)) {
            return false;
        }
        DefaultCacheBehavior other = (DefaultCacheBehavior) obj;
        return Objects.equals(targetOriginId(), other.targetOriginId())
                && Objects.equals(forwardedValues(), other.forwardedValues())
                && Objects.equals(trustedSigners(), other.trustedSigners())
                && Objects.equals(viewerProtocolPolicyAsString(), other.viewerProtocolPolicyAsString())
                && Objects.equals(minTTL(), other.minTTL()) && Objects.equals(allowedMethods(), other.allowedMethods())
                && Objects.equals(smoothStreaming(), other.smoothStreaming()) && Objects.equals(defaultTTL(), other.defaultTTL())
                && Objects.equals(maxTTL(), other.maxTTL()) && Objects.equals(compress(), other.compress())
                && Objects.equals(lambdaFunctionAssociations(), other.lambdaFunctionAssociations())
                && Objects.equals(fieldLevelEncryptionId(), other.fieldLevelEncryptionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DefaultCacheBehavior").add("TargetOriginId", targetOriginId())
                .add("ForwardedValues", forwardedValues()).add("TrustedSigners", trustedSigners())
                .add("ViewerProtocolPolicy", viewerProtocolPolicyAsString()).add("MinTTL", minTTL())
                .add("AllowedMethods", allowedMethods()).add("SmoothStreaming", smoothStreaming())
                .add("DefaultTTL", defaultTTL()).add("MaxTTL", maxTTL()).add("Compress", compress())
                .add("LambdaFunctionAssociations", lambdaFunctionAssociations())
                .add("FieldLevelEncryptionId", fieldLevelEncryptionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetOriginId":
            return Optional.ofNullable(clazz.cast(targetOriginId()));
        case "ForwardedValues":
            return Optional.ofNullable(clazz.cast(forwardedValues()));
        case "TrustedSigners":
            return Optional.ofNullable(clazz.cast(trustedSigners()));
        case "ViewerProtocolPolicy":
            return Optional.ofNullable(clazz.cast(viewerProtocolPolicyAsString()));
        case "MinTTL":
            return Optional.ofNullable(clazz.cast(minTTL()));
        case "AllowedMethods":
            return Optional.ofNullable(clazz.cast(allowedMethods()));
        case "SmoothStreaming":
            return Optional.ofNullable(clazz.cast(smoothStreaming()));
        case "DefaultTTL":
            return Optional.ofNullable(clazz.cast(defaultTTL()));
        case "MaxTTL":
            return Optional.ofNullable(clazz.cast(maxTTL()));
        case "Compress":
            return Optional.ofNullable(clazz.cast(compress()));
        case "LambdaFunctionAssociations":
            return Optional.ofNullable(clazz.cast(lambdaFunctionAssociations()));
        case "FieldLevelEncryptionId":
            return Optional.ofNullable(clazz.cast(fieldLevelEncryptionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefaultCacheBehavior, T> g) {
        return obj -> g.apply((DefaultCacheBehavior) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultCacheBehavior> {
        /**
         * <p>
         * The value of <code>ID</code> for the origin that you want CloudFront to route requests to when a request
         * matches the path pattern either for a cache behavior or for the default cache behavior in your distribution.
         * </p>
         * 
         * @param targetOriginId
         *        The value of <code>ID</code> for the origin that you want CloudFront to route requests to when a
         *        request matches the path pattern either for a cache behavior or for the default cache behavior in your
         *        distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetOriginId(String targetOriginId);

        /**
         * <p>
         * A complex type that specifies how CloudFront handles query strings and cookies.
         * </p>
         * 
         * @param forwardedValues
         *        A complex type that specifies how CloudFront handles query strings and cookies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forwardedValues(ForwardedValues forwardedValues);

        /**
         * <p>
         * A complex type that specifies how CloudFront handles query strings and cookies.
         * </p>
         * This is a convenience that creates an instance of the {@link ForwardedValues.Builder} avoiding the need to
         * create one manually via {@link ForwardedValues#builder()}.
         *
         * When the {@link Consumer} completes, {@link ForwardedValues.Builder#build()} is called immediately and its
         * result is passed to {@link #forwardedValues(ForwardedValues)}.
         * 
         * @param forwardedValues
         *        a consumer that will call methods on {@link ForwardedValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forwardedValues(ForwardedValues)
         */
        default Builder forwardedValues(Consumer<ForwardedValues.Builder> forwardedValues) {
            return forwardedValues(ForwardedValues.builder().applyMutation(forwardedValues).build());
        }

        /**
         * <p>
         * A complex type that specifies the AWS accounts, if any, that you want to allow to create signed URLs for
         * private content.
         * </p>
         * <p>
         * If you want to require signed URLs in requests for objects in the target origin that match the
         * <code>PathPattern</code> for this cache behavior, specify <code>true</code> for <code>Enabled</code>, and
         * specify the applicable values for <code>Quantity</code> and <code>Items</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
         * Content through CloudFront</a> in the <i> Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * If you don't want to require signed URLs in requests for objects that match <code>PathPattern</code>, specify
         * <code>false</code> for <code>Enabled</code> and <code>0</code> for <code>Quantity</code>. Omit
         * <code>Items</code>.
         * </p>
         * <p>
         * To add, change, or remove one or more trusted signers, change <code>Enabled</code> to <code>true</code> (if
         * it's currently <code>false</code>), change <code>Quantity</code> as applicable, and specify all of the
         * trusted signers that you want to include in the updated distribution.
         * </p>
         * 
         * @param trustedSigners
         *        A complex type that specifies the AWS accounts, if any, that you want to allow to create signed URLs
         *        for private content.</p>
         *        <p>
         *        If you want to require signed URLs in requests for objects in the target origin that match the
         *        <code>PathPattern</code> for this cache behavior, specify <code>true</code> for <code>Enabled</code>,
         *        and specify the applicable values for <code>Quantity</code> and <code>Items</code>. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
         *        Private Content through CloudFront</a> in the <i> Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <p>
         *        If you don't want to require signed URLs in requests for objects that match <code>PathPattern</code>,
         *        specify <code>false</code> for <code>Enabled</code> and <code>0</code> for <code>Quantity</code>. Omit
         *        <code>Items</code>.
         *        </p>
         *        <p>
         *        To add, change, or remove one or more trusted signers, change <code>Enabled</code> to
         *        <code>true</code> (if it's currently <code>false</code>), change <code>Quantity</code> as applicable,
         *        and specify all of the trusted signers that you want to include in the updated distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedSigners(TrustedSigners trustedSigners);

        /**
         * <p>
         * A complex type that specifies the AWS accounts, if any, that you want to allow to create signed URLs for
         * private content.
         * </p>
         * <p>
         * If you want to require signed URLs in requests for objects in the target origin that match the
         * <code>PathPattern</code> for this cache behavior, specify <code>true</code> for <code>Enabled</code>, and
         * specify the applicable values for <code>Quantity</code> and <code>Items</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
         * Content through CloudFront</a> in the <i> Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * If you don't want to require signed URLs in requests for objects that match <code>PathPattern</code>, specify
         * <code>false</code> for <code>Enabled</code> and <code>0</code> for <code>Quantity</code>. Omit
         * <code>Items</code>.
         * </p>
         * <p>
         * To add, change, or remove one or more trusted signers, change <code>Enabled</code> to <code>true</code> (if
         * it's currently <code>false</code>), change <code>Quantity</code> as applicable, and specify all of the
         * trusted signers that you want to include in the updated distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link TrustedSigners.Builder} avoiding the need to
         * create one manually via {@link TrustedSigners#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrustedSigners.Builder#build()} is called immediately and its
         * result is passed to {@link #trustedSigners(TrustedSigners)}.
         * 
         * @param trustedSigners
         *        a consumer that will call methods on {@link TrustedSigners.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trustedSigners(TrustedSigners)
         */
        default Builder trustedSigners(Consumer<TrustedSigners.Builder> trustedSigners) {
            return trustedSigners(TrustedSigners.builder().applyMutation(trustedSigners).build());
        }

        /**
         * <p>
         * The protocol that viewers can use to access the files in the origin specified by <code>TargetOriginId</code>
         * when a request matches the path pattern in <code>PathPattern</code>. You can specify the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>allow-all</code>: Viewers can use HTTP or HTTPS.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns an HTTP status code
         * of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request
         * using the new URL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403
         * (Forbidden).
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about requiring the HTTPS protocol, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html">Using an
         * HTTPS Connection to Access Your Objects</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <note>
         * <p>
         * The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is
         * never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we
         * recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an
         * edge location will return an object from the cache regardless of whether the current request protocol matches
         * the protocol used previously. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long
         * Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param viewerProtocolPolicy
         *        The protocol that viewers can use to access the files in the origin specified by
         *        <code>TargetOriginId</code> when a request matches the path pattern in <code>PathPattern</code>. You
         *        can specify the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>allow-all</code>: Viewers can use HTTP or HTTPS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns an HTTP status
         *        code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the
         *        request using the new URL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of
         *        403 (Forbidden).
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about requiring the HTTPS protocol, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html">Using
         *        an HTTPS Connection to Access Your Objects</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS
         *        is never to use any other protocol to fetch the object. If you have recently changed from HTTP to
         *        HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic.
         *        That means that an edge location will return an object from the cache regardless of whether the
         *        current request protocol matches the protocol used previously. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How
         *        Long Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         * @see ViewerProtocolPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewerProtocolPolicy
         */
        Builder viewerProtocolPolicy(String viewerProtocolPolicy);

        /**
         * <p>
         * The protocol that viewers can use to access the files in the origin specified by <code>TargetOriginId</code>
         * when a request matches the path pattern in <code>PathPattern</code>. You can specify the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>allow-all</code>: Viewers can use HTTP or HTTPS.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns an HTTP status code
         * of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request
         * using the new URL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403
         * (Forbidden).
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about requiring the HTTPS protocol, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html">Using an
         * HTTPS Connection to Access Your Objects</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <note>
         * <p>
         * The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is
         * never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we
         * recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an
         * edge location will return an object from the cache regardless of whether the current request protocol matches
         * the protocol used previously. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long
         * Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param viewerProtocolPolicy
         *        The protocol that viewers can use to access the files in the origin specified by
         *        <code>TargetOriginId</code> when a request matches the path pattern in <code>PathPattern</code>. You
         *        can specify the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>allow-all</code>: Viewers can use HTTP or HTTPS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns an HTTP status
         *        code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the
         *        request using the new URL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of
         *        403 (Forbidden).
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about requiring the HTTPS protocol, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/SecureConnections.html">Using
         *        an HTTPS Connection to Access Your Objects</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS
         *        is never to use any other protocol to fetch the object. If you have recently changed from HTTP to
         *        HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic.
         *        That means that an edge location will return an object from the cache regardless of whether the
         *        current request protocol matches the protocol used previously. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How
         *        Long Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         * @see ViewerProtocolPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewerProtocolPolicy
         */
        Builder viewerProtocolPolicy(ViewerProtocolPolicy viewerProtocolPolicy);

        /**
         * <p>
         * The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards
         * another request to your origin to determine whether the object has been updated. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long
         * Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to forward all headers to
         * your origin (under <code>Headers</code>, if you specify <code>1</code> for <code>Quantity</code> and
         * <code>*</code> for <code>Name</code>).
         * </p>
         * 
         * @param minTTL
         *        The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront
         *        forwards another request to your origin to determine whether the object has been updated. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How
         *        Long Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer
         *        Guide</i>.</p>
         *        <p>
         *        You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to forward all
         *        headers to your origin (under <code>Headers</code>, if you specify <code>1</code> for
         *        <code>Quantity</code> and <code>*</code> for <code>Name</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minTTL(Long minTTL);

        /**
         * Sets the value of the AllowedMethods property for this object.
         *
         * @param allowedMethods
         *        The new value for the AllowedMethods property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedMethods(AllowedMethods allowedMethods);

        /**
         * Sets the value of the AllowedMethods property for this object.
         *
         * This is a convenience that creates an instance of the {@link AllowedMethods.Builder} avoiding the need to
         * create one manually via {@link AllowedMethods#builder()}.
         *
         * When the {@link Consumer} completes, {@link AllowedMethods.Builder#build()} is called immediately and its
         * result is passed to {@link #allowedMethods(AllowedMethods)}.
         * 
         * @param allowedMethods
         *        a consumer that will call methods on {@link AllowedMethods.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allowedMethods(AllowedMethods)
         */
        default Builder allowedMethods(Consumer<AllowedMethods.Builder> allowedMethods) {
            return allowedMethods(AllowedMethods.builder().applyMutation(allowedMethods).build());
        }

        /**
         * <p>
         * Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the
         * origin that is associated with this cache behavior. If so, specify <code>true</code>; if not, specify
         * <code>false</code>. If you specify <code>true</code> for <code>SmoothStreaming</code>, you can still
         * distribute other content using this cache behavior if the content matches the value of
         * <code>PathPattern</code>.
         * </p>
         * 
         * @param smoothStreaming
         *        Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using
         *        the origin that is associated with this cache behavior. If so, specify <code>true</code>; if not,
         *        specify <code>false</code>. If you specify <code>true</code> for <code>SmoothStreaming</code>, you can
         *        still distribute other content using this cache behavior if the content matches the value of
         *        <code>PathPattern</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smoothStreaming(Boolean smoothStreaming);

        /**
         * <p>
         * The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards
         * another request to your origin to determine whether the object has been updated. The value that you specify
         * applies only when your origin does not add HTTP headers such as <code>Cache-Control max-age</code>,
         * <code>Cache-Control s-maxage</code>, and <code>Expires</code> to objects. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long
         * Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param defaultTTL
         *        The default amount of time that you want objects to stay in CloudFront caches before CloudFront
         *        forwards another request to your origin to determine whether the object has been updated. The value
         *        that you specify applies only when your origin does not add HTTP headers such as
         *        <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and <code>Expires</code> to
         *        objects. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How
         *        Long Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTTL(Long defaultTTL);

        /**
         * <p>
         * The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards
         * another request to your origin to determine whether the object has been updated. The value that you specify
         * applies only when your origin adds HTTP headers such as <code>Cache-Control max-age</code>,
         * <code>Cache-Control s-maxage</code>, and <code>Expires</code> to objects. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long
         * Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param maxTTL
         *        The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront
         *        forwards another request to your origin to determine whether the object has been updated. The value
         *        that you specify applies only when your origin adds HTTP headers such as
         *        <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and <code>Expires</code> to
         *        objects. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How
         *        Long Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxTTL(Long maxTTL);

        /**
         * <p>
         * Whether you want CloudFront to automatically compress certain files for this cache behavior. If so, specify
         * <code>true</code>; if not, specify <code>false</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html">Serving
         * Compressed Files</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param compress
         *        Whether you want CloudFront to automatically compress certain files for this cache behavior. If so,
         *        specify <code>true</code>; if not, specify <code>false</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html"
         *        >Serving Compressed Files</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compress(Boolean compress);

        /**
         * <p>
         * A complex type that contains zero or more Lambda function associations for a cache behavior.
         * </p>
         * 
         * @param lambdaFunctionAssociations
         *        A complex type that contains zero or more Lambda function associations for a cache behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionAssociations(LambdaFunctionAssociations lambdaFunctionAssociations);

        /**
         * <p>
         * A complex type that contains zero or more Lambda function associations for a cache behavior.
         * </p>
         * This is a convenience that creates an instance of the {@link LambdaFunctionAssociations.Builder} avoiding the
         * need to create one manually via {@link LambdaFunctionAssociations#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaFunctionAssociations.Builder#build()} is called immediately
         * and its result is passed to {@link #lambdaFunctionAssociations(LambdaFunctionAssociations)}.
         * 
         * @param lambdaFunctionAssociations
         *        a consumer that will call methods on {@link LambdaFunctionAssociations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunctionAssociations(LambdaFunctionAssociations)
         */
        default Builder lambdaFunctionAssociations(Consumer<LambdaFunctionAssociations.Builder> lambdaFunctionAssociations) {
            return lambdaFunctionAssociations(LambdaFunctionAssociations.builder().applyMutation(lambdaFunctionAssociations)
                    .build());
        }

        /**
         * <p>
         * The value of <code>ID</code> for the field-level encryption configuration that you want CloudFront to use for
         * encrypting specific fields of data for a cache behavior or for the default cache behavior in your
         * distribution.
         * </p>
         * 
         * @param fieldLevelEncryptionId
         *        The value of <code>ID</code> for the field-level encryption configuration that you want CloudFront to
         *        use for encrypting specific fields of data for a cache behavior or for the default cache behavior in
         *        your distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldLevelEncryptionId(String fieldLevelEncryptionId);
    }

    static final class BuilderImpl implements Builder {
        private String targetOriginId;

        private ForwardedValues forwardedValues;

        private TrustedSigners trustedSigners;

        private String viewerProtocolPolicy;

        private Long minTTL;

        private AllowedMethods allowedMethods;

        private Boolean smoothStreaming;

        private Long defaultTTL;

        private Long maxTTL;

        private Boolean compress;

        private LambdaFunctionAssociations lambdaFunctionAssociations;

        private String fieldLevelEncryptionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultCacheBehavior model) {
            targetOriginId(model.targetOriginId);
            forwardedValues(model.forwardedValues);
            trustedSigners(model.trustedSigners);
            viewerProtocolPolicy(model.viewerProtocolPolicy);
            minTTL(model.minTTL);
            allowedMethods(model.allowedMethods);
            smoothStreaming(model.smoothStreaming);
            defaultTTL(model.defaultTTL);
            maxTTL(model.maxTTL);
            compress(model.compress);
            lambdaFunctionAssociations(model.lambdaFunctionAssociations);
            fieldLevelEncryptionId(model.fieldLevelEncryptionId);
        }

        public final String getTargetOriginId() {
            return targetOriginId;
        }

        @Override
        public final Builder targetOriginId(String targetOriginId) {
            this.targetOriginId = targetOriginId;
            return this;
        }

        public final void setTargetOriginId(String targetOriginId) {
            this.targetOriginId = targetOriginId;
        }

        public final ForwardedValues.Builder getForwardedValues() {
            return forwardedValues != null ? forwardedValues.toBuilder() : null;
        }

        @Override
        public final Builder forwardedValues(ForwardedValues forwardedValues) {
            this.forwardedValues = forwardedValues;
            return this;
        }

        public final void setForwardedValues(ForwardedValues.BuilderImpl forwardedValues) {
            this.forwardedValues = forwardedValues != null ? forwardedValues.build() : null;
        }

        public final TrustedSigners.Builder getTrustedSigners() {
            return trustedSigners != null ? trustedSigners.toBuilder() : null;
        }

        @Override
        public final Builder trustedSigners(TrustedSigners trustedSigners) {
            this.trustedSigners = trustedSigners;
            return this;
        }

        public final void setTrustedSigners(TrustedSigners.BuilderImpl trustedSigners) {
            this.trustedSigners = trustedSigners != null ? trustedSigners.build() : null;
        }

        public final String getViewerProtocolPolicyAsString() {
            return viewerProtocolPolicy;
        }

        @Override
        public final Builder viewerProtocolPolicy(String viewerProtocolPolicy) {
            this.viewerProtocolPolicy = viewerProtocolPolicy;
            return this;
        }

        @Override
        public final Builder viewerProtocolPolicy(ViewerProtocolPolicy viewerProtocolPolicy) {
            this.viewerProtocolPolicy(viewerProtocolPolicy.toString());
            return this;
        }

        public final void setViewerProtocolPolicy(String viewerProtocolPolicy) {
            this.viewerProtocolPolicy = viewerProtocolPolicy;
        }

        public final Long getMinTTL() {
            return minTTL;
        }

        @Override
        public final Builder minTTL(Long minTTL) {
            this.minTTL = minTTL;
            return this;
        }

        public final void setMinTTL(Long minTTL) {
            this.minTTL = minTTL;
        }

        public final AllowedMethods.Builder getAllowedMethods() {
            return allowedMethods != null ? allowedMethods.toBuilder() : null;
        }

        @Override
        public final Builder allowedMethods(AllowedMethods allowedMethods) {
            this.allowedMethods = allowedMethods;
            return this;
        }

        public final void setAllowedMethods(AllowedMethods.BuilderImpl allowedMethods) {
            this.allowedMethods = allowedMethods != null ? allowedMethods.build() : null;
        }

        public final Boolean getSmoothStreaming() {
            return smoothStreaming;
        }

        @Override
        public final Builder smoothStreaming(Boolean smoothStreaming) {
            this.smoothStreaming = smoothStreaming;
            return this;
        }

        public final void setSmoothStreaming(Boolean smoothStreaming) {
            this.smoothStreaming = smoothStreaming;
        }

        public final Long getDefaultTTL() {
            return defaultTTL;
        }

        @Override
        public final Builder defaultTTL(Long defaultTTL) {
            this.defaultTTL = defaultTTL;
            return this;
        }

        public final void setDefaultTTL(Long defaultTTL) {
            this.defaultTTL = defaultTTL;
        }

        public final Long getMaxTTL() {
            return maxTTL;
        }

        @Override
        public final Builder maxTTL(Long maxTTL) {
            this.maxTTL = maxTTL;
            return this;
        }

        public final void setMaxTTL(Long maxTTL) {
            this.maxTTL = maxTTL;
        }

        public final Boolean getCompress() {
            return compress;
        }

        @Override
        public final Builder compress(Boolean compress) {
            this.compress = compress;
            return this;
        }

        public final void setCompress(Boolean compress) {
            this.compress = compress;
        }

        public final LambdaFunctionAssociations.Builder getLambdaFunctionAssociations() {
            return lambdaFunctionAssociations != null ? lambdaFunctionAssociations.toBuilder() : null;
        }

        @Override
        public final Builder lambdaFunctionAssociations(LambdaFunctionAssociations lambdaFunctionAssociations) {
            this.lambdaFunctionAssociations = lambdaFunctionAssociations;
            return this;
        }

        public final void setLambdaFunctionAssociations(LambdaFunctionAssociations.BuilderImpl lambdaFunctionAssociations) {
            this.lambdaFunctionAssociations = lambdaFunctionAssociations != null ? lambdaFunctionAssociations.build() : null;
        }

        public final String getFieldLevelEncryptionId() {
            return fieldLevelEncryptionId;
        }

        @Override
        public final Builder fieldLevelEncryptionId(String fieldLevelEncryptionId) {
            this.fieldLevelEncryptionId = fieldLevelEncryptionId;
            return this;
        }

        public final void setFieldLevelEncryptionId(String fieldLevelEncryptionId) {
            this.fieldLevelEncryptionId = fieldLevelEncryptionId;
        }

        @Override
        public DefaultCacheBehavior build() {
            return new DefaultCacheBehavior(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
