/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.ActiveTrustedSigners;
import software.amazon.awssdk.services.cloudfront.model.AliasICPRecordal;
import software.amazon.awssdk.services.cloudfront.model.AliasICPRecordalsCopier;
import software.amazon.awssdk.services.cloudfront.model.DistributionConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Distribution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Distribution> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Distribution.getter(Distribution::id)).setter(Distribution.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Distribution.getter(Distribution::arn)).setter(Distribution.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").unmarshallLocationName("ARN").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Distribution.getter(Distribution::status)).setter(Distribution.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("Status").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Distribution.getter(Distribution::lastModifiedTime)).setter(Distribution.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").unmarshallLocationName("LastModifiedTime").build()}).build();
    private static final SdkField<Integer> IN_PROGRESS_INVALIDATION_BATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Distribution.getter(Distribution::inProgressInvalidationBatches)).setter(Distribution.setter(Builder::inProgressInvalidationBatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InProgressInvalidationBatches").unmarshallLocationName("InProgressInvalidationBatches").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Distribution.getter(Distribution::domainName)).setter(Distribution.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").unmarshallLocationName("DomainName").build()}).build();
    private static final SdkField<ActiveTrustedSigners> ACTIVE_TRUSTED_SIGNERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Distribution.getter(Distribution::activeTrustedSigners)).setter(Distribution.setter(Builder::activeTrustedSigners)).constructor(ActiveTrustedSigners::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveTrustedSigners").unmarshallLocationName("ActiveTrustedSigners").build()}).build();
    private static final SdkField<DistributionConfig> DISTRIBUTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Distribution.getter(Distribution::distributionConfig)).setter(Distribution.setter(Builder::distributionConfig)).constructor(DistributionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistributionConfig").unmarshallLocationName("DistributionConfig").build()}).build();
    private static final SdkField<List<AliasICPRecordal>> ALIAS_ICP_RECORDALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Distribution.getter(Distribution::aliasICPRecordals)).setter(Distribution.setter(Builder::aliasICPRecordals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasICPRecordals").unmarshallLocationName("AliasICPRecordals").build(), ListTrait.builder().memberLocationName("AliasICPRecordal").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AliasICPRecordal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasICPRecordal").unmarshallLocationName("AliasICPRecordal").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, STATUS_FIELD, LAST_MODIFIED_TIME_FIELD, IN_PROGRESS_INVALIDATION_BATCHES_FIELD, DOMAIN_NAME_FIELD, ACTIVE_TRUSTED_SIGNERS_FIELD, DISTRIBUTION_CONFIG_FIELD, ALIAS_ICP_RECORDALS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String status;
    private final Instant lastModifiedTime;
    private final Integer inProgressInvalidationBatches;
    private final String domainName;
    private final ActiveTrustedSigners activeTrustedSigners;
    private final DistributionConfig distributionConfig;
    private final List<AliasICPRecordal> aliasICPRecordals;

    private Distribution(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.inProgressInvalidationBatches = builder.inProgressInvalidationBatches;
        this.domainName = builder.domainName;
        this.activeTrustedSigners = builder.activeTrustedSigners;
        this.distributionConfig = builder.distributionConfig;
        this.aliasICPRecordals = builder.aliasICPRecordals;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public String status() {
        return this.status;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Integer inProgressInvalidationBatches() {
        return this.inProgressInvalidationBatches;
    }

    public String domainName() {
        return this.domainName;
    }

    public ActiveTrustedSigners activeTrustedSigners() {
        return this.activeTrustedSigners;
    }

    public DistributionConfig distributionConfig() {
        return this.distributionConfig;
    }

    public List<AliasICPRecordal> aliasICPRecordals() {
        return this.aliasICPRecordals;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.inProgressInvalidationBatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeTrustedSigners());
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasICPRecordals());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Distribution)) {
            return false;
        }
        Distribution other = (Distribution)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.inProgressInvalidationBatches(), other.inProgressInvalidationBatches()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.activeTrustedSigners(), other.activeTrustedSigners()) && Objects.equals(this.distributionConfig(), other.distributionConfig()) && Objects.equals(this.aliasICPRecordals(), other.aliasICPRecordals());
    }

    public String toString() {
        return ToString.builder((String)"Distribution").add("Id", (Object)this.id()).add("ARN", (Object)this.arn()).add("Status", (Object)this.status()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("InProgressInvalidationBatches", (Object)this.inProgressInvalidationBatches()).add("DomainName", (Object)this.domainName()).add("ActiveTrustedSigners", (Object)this.activeTrustedSigners()).add("DistributionConfig", (Object)this.distributionConfig()).add("AliasICPRecordals", this.aliasICPRecordals()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "InProgressInvalidationBatches": {
                return Optional.ofNullable(clazz.cast(this.inProgressInvalidationBatches()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ActiveTrustedSigners": {
                return Optional.ofNullable(clazz.cast(this.activeTrustedSigners()));
            }
            case "DistributionConfig": {
                return Optional.ofNullable(clazz.cast(this.distributionConfig()));
            }
            case "AliasICPRecordals": {
                return Optional.ofNullable(clazz.cast(this.aliasICPRecordals()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Distribution, T> g) {
        return obj -> g.apply((Distribution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String status;
        private Instant lastModifiedTime;
        private Integer inProgressInvalidationBatches;
        private String domainName;
        private ActiveTrustedSigners activeTrustedSigners;
        private DistributionConfig distributionConfig;
        private List<AliasICPRecordal> aliasICPRecordals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Distribution model) {
            this.id(model.id);
            this.arn(model.arn);
            this.status(model.status);
            this.lastModifiedTime(model.lastModifiedTime);
            this.inProgressInvalidationBatches(model.inProgressInvalidationBatches);
            this.domainName(model.domainName);
            this.activeTrustedSigners(model.activeTrustedSigners);
            this.distributionConfig(model.distributionConfig);
            this.aliasICPRecordals(model.aliasICPRecordals);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final Integer getInProgressInvalidationBatches() {
            return this.inProgressInvalidationBatches;
        }

        @Override
        public final Builder inProgressInvalidationBatches(Integer inProgressInvalidationBatches) {
            this.inProgressInvalidationBatches = inProgressInvalidationBatches;
            return this;
        }

        public final void setInProgressInvalidationBatches(Integer inProgressInvalidationBatches) {
            this.inProgressInvalidationBatches = inProgressInvalidationBatches;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final ActiveTrustedSigners.Builder getActiveTrustedSigners() {
            return this.activeTrustedSigners != null ? this.activeTrustedSigners.toBuilder() : null;
        }

        @Override
        public final Builder activeTrustedSigners(ActiveTrustedSigners activeTrustedSigners) {
            this.activeTrustedSigners = activeTrustedSigners;
            return this;
        }

        public final void setActiveTrustedSigners(ActiveTrustedSigners.BuilderImpl activeTrustedSigners) {
            this.activeTrustedSigners = activeTrustedSigners != null ? activeTrustedSigners.build() : null;
        }

        public final DistributionConfig.Builder getDistributionConfig() {
            return this.distributionConfig != null ? this.distributionConfig.toBuilder() : null;
        }

        @Override
        public final Builder distributionConfig(DistributionConfig distributionConfig) {
            this.distributionConfig = distributionConfig;
            return this;
        }

        public final void setDistributionConfig(DistributionConfig.BuilderImpl distributionConfig) {
            this.distributionConfig = distributionConfig != null ? distributionConfig.build() : null;
        }

        public final Collection<AliasICPRecordal.Builder> getAliasICPRecordals() {
            return this.aliasICPRecordals != null ? (Collection)this.aliasICPRecordals.stream().map(AliasICPRecordal::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder aliasICPRecordals(Collection<AliasICPRecordal> aliasICPRecordals) {
            this.aliasICPRecordals = AliasICPRecordalsCopier.copy(aliasICPRecordals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliasICPRecordals(AliasICPRecordal ... aliasICPRecordals) {
            this.aliasICPRecordals(Arrays.asList(aliasICPRecordals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliasICPRecordals(Consumer<AliasICPRecordal.Builder> ... aliasICPRecordals) {
            this.aliasICPRecordals(Stream.of(aliasICPRecordals).map(c -> (AliasICPRecordal)((AliasICPRecordal.Builder)AliasICPRecordal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAliasICPRecordals(Collection<AliasICPRecordal.BuilderImpl> aliasICPRecordals) {
            this.aliasICPRecordals = AliasICPRecordalsCopier.copyFromBuilder(aliasICPRecordals);
        }

        public Distribution build() {
            return new Distribution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Distribution> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder inProgressInvalidationBatches(Integer var1);

        public Builder domainName(String var1);

        public Builder activeTrustedSigners(ActiveTrustedSigners var1);

        default public Builder activeTrustedSigners(Consumer<ActiveTrustedSigners.Builder> activeTrustedSigners) {
            return this.activeTrustedSigners((ActiveTrustedSigners)((ActiveTrustedSigners.Builder)ActiveTrustedSigners.builder().applyMutation(activeTrustedSigners)).build());
        }

        public Builder distributionConfig(DistributionConfig var1);

        default public Builder distributionConfig(Consumer<DistributionConfig.Builder> distributionConfig) {
            return this.distributionConfig((DistributionConfig)((DistributionConfig.Builder)DistributionConfig.builder().applyMutation(distributionConfig)).build());
        }

        public Builder aliasICPRecordals(Collection<AliasICPRecordal> var1);

        public Builder aliasICPRecordals(AliasICPRecordal ... var1);

        public Builder aliasICPRecordals(Consumer<AliasICPRecordal.Builder> ... var1);
    }
}

