/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileSummary;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FieldLevelEncryptionProfileList
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FieldLevelEncryptionProfileList> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FieldLevelEncryptionProfileList.getter(FieldLevelEncryptionProfileList::nextMarker)).setter(FieldLevelEncryptionProfileList.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").unmarshallLocationName("NextMarker").build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(FieldLevelEncryptionProfileList.getter(FieldLevelEncryptionProfileList::maxItems)).setter(FieldLevelEncryptionProfileList.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").unmarshallLocationName("MaxItems").build()}).build();
    private static final SdkField<Integer> QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(FieldLevelEncryptionProfileList.getter(FieldLevelEncryptionProfileList::quantity)).setter(FieldLevelEncryptionProfileList.setter(Builder::quantity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity").unmarshallLocationName("Quantity").build()}).build();
    private static final SdkField<List<FieldLevelEncryptionProfileSummary>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(FieldLevelEncryptionProfileList.getter(FieldLevelEncryptionProfileList::items)).setter(FieldLevelEncryptionProfileList.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").unmarshallLocationName("Items").build(), ListTrait.builder().memberLocationName("FieldLevelEncryptionProfileSummary").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldLevelEncryptionProfileSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldLevelEncryptionProfileSummary").unmarshallLocationName("FieldLevelEncryptionProfileSummary").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, MAX_ITEMS_FIELD, QUANTITY_FIELD, ITEMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String nextMarker;
    private final Integer maxItems;
    private final Integer quantity;
    private final List<FieldLevelEncryptionProfileSummary> items;

    private FieldLevelEncryptionProfileList(BuilderImpl builder) {
        this.nextMarker = builder.nextMarker;
        this.maxItems = builder.maxItems;
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    public Integer quantity() {
        return this.quantity;
    }

    public List<FieldLevelEncryptionProfileSummary> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.items());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldLevelEncryptionProfileList)) {
            return false;
        }
        FieldLevelEncryptionProfileList other = (FieldLevelEncryptionProfileList)obj;
        return Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.maxItems(), other.maxItems()) && Objects.equals(this.quantity(), other.quantity()) && Objects.equals(this.items(), other.items());
    }

    public String toString() {
        return ToString.builder((String)"FieldLevelEncryptionProfileList").add("NextMarker", (Object)this.nextMarker()).add("MaxItems", (Object)this.maxItems()).add("Quantity", (Object)this.quantity()).add("Items", this.items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "Quantity": {
                return Optional.ofNullable(clazz.cast(this.quantity()));
            }
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FieldLevelEncryptionProfileList, T> g) {
        return obj -> g.apply((FieldLevelEncryptionProfileList)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String nextMarker;
        private Integer maxItems;
        private Integer quantity;
        private List<FieldLevelEncryptionProfileSummary> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FieldLevelEncryptionProfileList model) {
            this.nextMarker(model.nextMarker);
            this.maxItems(model.maxItems);
            this.quantity(model.quantity);
            this.items(model.items);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<FieldLevelEncryptionProfileSummary.Builder> getItems() {
            return this.items != null ? (Collection)this.items.stream().map(FieldLevelEncryptionProfileSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<FieldLevelEncryptionProfileSummary> items) {
            this.items = FieldLevelEncryptionProfileSummaryListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(FieldLevelEncryptionProfileSummary ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<FieldLevelEncryptionProfileSummary.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (FieldLevelEncryptionProfileSummary)((FieldLevelEncryptionProfileSummary.Builder)FieldLevelEncryptionProfileSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<FieldLevelEncryptionProfileSummary.BuilderImpl> items) {
            this.items = FieldLevelEncryptionProfileSummaryListCopier.copyFromBuilder(items);
        }

        public FieldLevelEncryptionProfileList build() {
            return new FieldLevelEncryptionProfileList(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FieldLevelEncryptionProfileList> {
        public Builder nextMarker(String var1);

        public Builder maxItems(Integer var1);

        public Builder quantity(Integer var1);

        public Builder items(Collection<FieldLevelEncryptionProfileSummary> var1);

        public Builder items(FieldLevelEncryptionProfileSummary ... var1);

        public Builder items(Consumer<FieldLevelEncryptionProfileSummary.Builder> ... var1);
    }
}

