/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.ListPublicKeysRequest;
import software.amazon.awssdk.services.cloudfront.model.ListPublicKeysResponse;
import software.amazon.awssdk.services.cloudfront.model.PublicKeySummary;

public class ListPublicKeysPublisher
implements SdkPublisher<ListPublicKeysResponse> {
    private final CloudFrontAsyncClient client;
    private final ListPublicKeysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPublicKeysPublisher(CloudFrontAsyncClient client, ListPublicKeysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPublicKeysPublisher(CloudFrontAsyncClient client, ListPublicKeysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPublicKeysResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPublicKeysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PublicKeySummary> items() {
        return this.flatMapIterable(response -> response.publicKeyList().items());
    }

    private class ListPublicKeysResponseFetcher
    implements AsyncPageFetcher<ListPublicKeysResponse> {
        private ListPublicKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListPublicKeysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.publicKeyList().nextMarker());
        }

        public CompletableFuture<ListPublicKeysResponse> nextPage(ListPublicKeysResponse previousPage) {
            if (previousPage == null) {
                return ListPublicKeysPublisher.this.client.listPublicKeys(ListPublicKeysPublisher.this.firstRequest);
            }
            return ListPublicKeysPublisher.this.client.listPublicKeys((ListPublicKeysRequest)((Object)ListPublicKeysPublisher.this.firstRequest.toBuilder().marker(previousPage.publicKeyList().nextMarker()).build()));
        }
    }
}

