/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.DistributionSummary;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsResponse;

public class ListDistributionsPublisher
implements SdkPublisher<ListDistributionsResponse> {
    private final CloudFrontAsyncClient client;
    private final ListDistributionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDistributionsPublisher(CloudFrontAsyncClient client, ListDistributionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDistributionsPublisher(CloudFrontAsyncClient client, ListDistributionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDistributionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDistributionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DistributionSummary> items() {
        return this.flatMapIterable(response -> response.distributionList().items());
    }

    private class ListDistributionsResponseFetcher
    implements AsyncPageFetcher<ListDistributionsResponse> {
        private ListDistributionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDistributionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.distributionList().nextMarker());
        }

        public CompletableFuture<ListDistributionsResponse> nextPage(ListDistributionsResponse previousPage) {
            if (previousPage == null) {
                return ListDistributionsPublisher.this.client.listDistributions(ListDistributionsPublisher.this.firstRequest);
            }
            return ListDistributionsPublisher.this.client.listDistributions((ListDistributionsRequest)((Object)ListDistributionsPublisher.this.firstRequest.toBuilder().marker(previousPage.distributionList().nextMarker()).build()));
        }
    }
}

