/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.DistributionSummary;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByTrustStoreRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByTrustStoreResponse;

public class ListDistributionsByTrustStorePublisher
implements SdkPublisher<ListDistributionsByTrustStoreResponse> {
    private final CloudFrontAsyncClient client;
    private final ListDistributionsByTrustStoreRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDistributionsByTrustStorePublisher(CloudFrontAsyncClient client, ListDistributionsByTrustStoreRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDistributionsByTrustStorePublisher(CloudFrontAsyncClient client, ListDistributionsByTrustStoreRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDistributionsByTrustStoreResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDistributionsByTrustStoreResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DistributionSummary> items() {
        return this.flatMapIterable(response -> response.distributionList().items());
    }

    private class ListDistributionsByTrustStoreResponseFetcher
    implements AsyncPageFetcher<ListDistributionsByTrustStoreResponse> {
        private ListDistributionsByTrustStoreResponseFetcher() {
        }

        public boolean hasNextPage(ListDistributionsByTrustStoreResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.distributionList().nextMarker());
        }

        public CompletableFuture<ListDistributionsByTrustStoreResponse> nextPage(ListDistributionsByTrustStoreResponse previousPage) {
            if (previousPage == null) {
                return ListDistributionsByTrustStorePublisher.this.client.listDistributionsByTrustStore(ListDistributionsByTrustStorePublisher.this.firstRequest);
            }
            return ListDistributionsByTrustStorePublisher.this.client.listDistributionsByTrustStore((ListDistributionsByTrustStoreRequest)((Object)ListDistributionsByTrustStorePublisher.this.firstRequest.toBuilder().marker(previousPage.distributionList().nextMarker()).build()));
        }
    }
}

