/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.ConnectionGroupSummary;
import software.amazon.awssdk.services.cloudfront.model.ListConnectionGroupsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListConnectionGroupsResponse;

public class ListConnectionGroupsPublisher
implements SdkPublisher<ListConnectionGroupsResponse> {
    private final CloudFrontAsyncClient client;
    private final ListConnectionGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConnectionGroupsPublisher(CloudFrontAsyncClient client, ListConnectionGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConnectionGroupsPublisher(CloudFrontAsyncClient client, ListConnectionGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConnectionGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConnectionGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConnectionGroupSummary> connectionGroups() {
        return this.flatMapIterable(response -> response.connectionGroups());
    }

    private class ListConnectionGroupsResponseFetcher
    implements AsyncPageFetcher<ListConnectionGroupsResponse> {
        private ListConnectionGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListConnectionGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListConnectionGroupsResponse> nextPage(ListConnectionGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListConnectionGroupsPublisher.this.client.listConnectionGroups(ListConnectionGroupsPublisher.this.firstRequest);
            }
            return ListConnectionGroupsPublisher.this.client.listConnectionGroups((ListConnectionGroupsRequest)((Object)ListConnectionGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

