/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentity;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCloudFrontOriginAccessIdentityResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, GetCloudFrontOriginAccessIdentityResponse> {
    private static final SdkField<CloudFrontOriginAccessIdentity> CLOUD_FRONT_ORIGIN_ACCESS_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudFrontOriginAccessIdentity").getter(GetCloudFrontOriginAccessIdentityResponse.getter(GetCloudFrontOriginAccessIdentityResponse::cloudFrontOriginAccessIdentity)).setter(GetCloudFrontOriginAccessIdentityResponse.setter(Builder::cloudFrontOriginAccessIdentity)).constructor(CloudFrontOriginAccessIdentity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFrontOriginAccessIdentity").unmarshallLocationName("CloudFrontOriginAccessIdentity").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(GetCloudFrontOriginAccessIdentityResponse.getter(GetCloudFrontOriginAccessIdentityResponse::eTag)).setter(GetCloudFrontOriginAccessIdentityResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_FRONT_ORIGIN_ACCESS_IDENTITY_FIELD, E_TAG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCloudFrontOriginAccessIdentityResponse.memberNameToFieldInitializer();
    private final CloudFrontOriginAccessIdentity cloudFrontOriginAccessIdentity;
    private final String eTag;

    private GetCloudFrontOriginAccessIdentityResponse(BuilderImpl builder) {
        super(builder);
        this.cloudFrontOriginAccessIdentity = builder.cloudFrontOriginAccessIdentity;
        this.eTag = builder.eTag;
    }

    public final CloudFrontOriginAccessIdentity cloudFrontOriginAccessIdentity() {
        return this.cloudFrontOriginAccessIdentity;
    }

    public final String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFrontOriginAccessIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCloudFrontOriginAccessIdentityResponse)) {
            return false;
        }
        GetCloudFrontOriginAccessIdentityResponse other = (GetCloudFrontOriginAccessIdentityResponse)((Object)obj);
        return Objects.equals(this.cloudFrontOriginAccessIdentity(), other.cloudFrontOriginAccessIdentity()) && Objects.equals(this.eTag(), other.eTag());
    }

    public final String toString() {
        return ToString.builder((String)"GetCloudFrontOriginAccessIdentityResponse").add("CloudFrontOriginAccessIdentity", (Object)this.cloudFrontOriginAccessIdentity()).add("ETag", (Object)this.eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudFrontOriginAccessIdentity": {
                return Optional.ofNullable(clazz.cast(this.cloudFrontOriginAccessIdentity()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CloudFrontOriginAccessIdentity", CLOUD_FRONT_ORIGIN_ACCESS_IDENTITY_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCloudFrontOriginAccessIdentityResponse, T> g) {
        return obj -> g.apply((GetCloudFrontOriginAccessIdentityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private CloudFrontOriginAccessIdentity cloudFrontOriginAccessIdentity;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCloudFrontOriginAccessIdentityResponse model) {
            super(model);
            this.cloudFrontOriginAccessIdentity(model.cloudFrontOriginAccessIdentity);
            this.eTag(model.eTag);
        }

        public final CloudFrontOriginAccessIdentity.Builder getCloudFrontOriginAccessIdentity() {
            return this.cloudFrontOriginAccessIdentity != null ? this.cloudFrontOriginAccessIdentity.toBuilder() : null;
        }

        public final void setCloudFrontOriginAccessIdentity(CloudFrontOriginAccessIdentity.BuilderImpl cloudFrontOriginAccessIdentity) {
            this.cloudFrontOriginAccessIdentity = cloudFrontOriginAccessIdentity != null ? cloudFrontOriginAccessIdentity.build() : null;
        }

        @Override
        public final Builder cloudFrontOriginAccessIdentity(CloudFrontOriginAccessIdentity cloudFrontOriginAccessIdentity) {
            this.cloudFrontOriginAccessIdentity = cloudFrontOriginAccessIdentity;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public GetCloudFrontOriginAccessIdentityResponse build() {
            return new GetCloudFrontOriginAccessIdentityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCloudFrontOriginAccessIdentityResponse> {
        public Builder cloudFrontOriginAccessIdentity(CloudFrontOriginAccessIdentity var1);

        default public Builder cloudFrontOriginAccessIdentity(Consumer<CloudFrontOriginAccessIdentity.Builder> cloudFrontOriginAccessIdentity) {
            return this.cloudFrontOriginAccessIdentity((CloudFrontOriginAccessIdentity)((CloudFrontOriginAccessIdentity.Builder)CloudFrontOriginAccessIdentity.builder().applyMutation(cloudFrontOriginAccessIdentity)).build());
        }

        public Builder eTag(String var1);
    }
}

