/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A viewer mTLS configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ViewerMtlsConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ViewerMtlsConfig.Builder, ViewerMtlsConfig> {
    private static final SdkField<String> MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Mode")
            .getter(getter(ViewerMtlsConfig::modeAsString))
            .setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode")
                    .unmarshallLocationName("Mode").build()).build();

    private static final SdkField<TrustStoreConfig> TRUST_STORE_CONFIG_FIELD = SdkField
            .<TrustStoreConfig> builder(MarshallingType.SDK_POJO)
            .memberName("TrustStoreConfig")
            .getter(getter(ViewerMtlsConfig::trustStoreConfig))
            .setter(setter(Builder::trustStoreConfig))
            .constructor(TrustStoreConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStoreConfig")
                    .unmarshallLocationName("TrustStoreConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD,
            TRUST_STORE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String mode;

    private final TrustStoreConfig trustStoreConfig;

    private ViewerMtlsConfig(BuilderImpl builder) {
        this.mode = builder.mode;
        this.trustStoreConfig = builder.trustStoreConfig;
    }

    /**
     * <p>
     * The viewer mTLS mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ViewerMtlsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The viewer mTLS mode.
     * @see ViewerMtlsMode
     */
    public final ViewerMtlsMode mode() {
        return ViewerMtlsMode.fromValue(mode);
    }

    /**
     * <p>
     * The viewer mTLS mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ViewerMtlsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The viewer mTLS mode.
     * @see ViewerMtlsMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * The trust store configuration associated with the viewer mTLS configuration.
     * </p>
     * 
     * @return The trust store configuration associated with the viewer mTLS configuration.
     */
    public final TrustStoreConfig trustStoreConfig() {
        return trustStoreConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(trustStoreConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewerMtlsConfig)) {
            return false;
        }
        ViewerMtlsConfig other = (ViewerMtlsConfig) obj;
        return Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(trustStoreConfig(), other.trustStoreConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ViewerMtlsConfig").add("Mode", modeAsString()).add("TrustStoreConfig", trustStoreConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "TrustStoreConfig":
            return Optional.ofNullable(clazz.cast(trustStoreConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Mode", MODE_FIELD);
        map.put("TrustStoreConfig", TRUST_STORE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ViewerMtlsConfig, T> g) {
        return obj -> g.apply((ViewerMtlsConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ViewerMtlsConfig> {
        /**
         * <p>
         * The viewer mTLS mode.
         * </p>
         * 
         * @param mode
         *        The viewer mTLS mode.
         * @see ViewerMtlsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewerMtlsMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The viewer mTLS mode.
         * </p>
         * 
         * @param mode
         *        The viewer mTLS mode.
         * @see ViewerMtlsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewerMtlsMode
         */
        Builder mode(ViewerMtlsMode mode);

        /**
         * <p>
         * The trust store configuration associated with the viewer mTLS configuration.
         * </p>
         * 
         * @param trustStoreConfig
         *        The trust store configuration associated with the viewer mTLS configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustStoreConfig(TrustStoreConfig trustStoreConfig);

        /**
         * <p>
         * The trust store configuration associated with the viewer mTLS configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrustStoreConfig.Builder} avoiding the
         * need to create one manually via {@link TrustStoreConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrustStoreConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #trustStoreConfig(TrustStoreConfig)}.
         * 
         * @param trustStoreConfig
         *        a consumer that will call methods on {@link TrustStoreConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trustStoreConfig(TrustStoreConfig)
         */
        default Builder trustStoreConfig(Consumer<TrustStoreConfig.Builder> trustStoreConfig) {
            return trustStoreConfig(TrustStoreConfig.builder().applyMutation(trustStoreConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String mode;

        private TrustStoreConfig trustStoreConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ViewerMtlsConfig model) {
            mode(model.mode);
            trustStoreConfig(model.trustStoreConfig);
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ViewerMtlsMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final TrustStoreConfig.Builder getTrustStoreConfig() {
            return trustStoreConfig != null ? trustStoreConfig.toBuilder() : null;
        }

        public final void setTrustStoreConfig(TrustStoreConfig.BuilderImpl trustStoreConfig) {
            this.trustStoreConfig = trustStoreConfig != null ? trustStoreConfig.build() : null;
        }

        @Override
        public final Builder trustStoreConfig(TrustStoreConfig trustStoreConfig) {
            this.trustStoreConfig = trustStoreConfig;
            return this;
        }

        @Override
        public ViewerMtlsConfig build() {
            return new ViewerMtlsConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
