/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConnectionFunctionRequest extends CloudFrontRequest implements
        ToCopyableBuilder<UpdateConnectionFunctionRequest.Builder, UpdateConnectionFunctionRequest> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(UpdateConnectionFunctionRequest::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> IF_MATCH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IfMatch")
            .getter(getter(UpdateConnectionFunctionRequest::ifMatch))
            .setter(setter(Builder::ifMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match")
                    .unmarshallLocationName("If-Match").build()).build();

    private static final SdkField<FunctionConfig> CONNECTION_FUNCTION_CONFIG_FIELD = SdkField
            .<FunctionConfig> builder(MarshallingType.SDK_POJO)
            .memberName("ConnectionFunctionConfig")
            .getter(getter(UpdateConnectionFunctionRequest::connectionFunctionConfig))
            .setter(setter(Builder::connectionFunctionConfig))
            .constructor(FunctionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionFunctionConfig")
                    .unmarshallLocationName("ConnectionFunctionConfig").build()).build();

    private static final SdkField<SdkBytes> CONNECTION_FUNCTION_CODE_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("ConnectionFunctionCode")
            .getter(getter(UpdateConnectionFunctionRequest::connectionFunctionCode))
            .setter(setter(Builder::connectionFunctionCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionFunctionCode")
                    .unmarshallLocationName("ConnectionFunctionCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, IF_MATCH_FIELD,
            CONNECTION_FUNCTION_CONFIG_FIELD, CONNECTION_FUNCTION_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String ifMatch;

    private final FunctionConfig connectionFunctionConfig;

    private final SdkBytes connectionFunctionCode;

    private UpdateConnectionFunctionRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.ifMatch = builder.ifMatch;
        this.connectionFunctionConfig = builder.connectionFunctionConfig;
        this.connectionFunctionCode = builder.connectionFunctionCode;
    }

    /**
     * <p>
     * The connection function ID.
     * </p>
     * 
     * @return The connection function ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The current version (<code>ETag</code> value) of the connection function you are updating.
     * </p>
     * 
     * @return The current version (<code>ETag</code> value) of the connection function you are updating.
     */
    public final String ifMatch() {
        return ifMatch;
    }

    /**
     * Returns the value of the ConnectionFunctionConfig property for this object.
     * 
     * @return The value of the ConnectionFunctionConfig property for this object.
     */
    public final FunctionConfig connectionFunctionConfig() {
        return connectionFunctionConfig;
    }

    /**
     * <p>
     * The connection function code.
     * </p>
     * 
     * @return The connection function code.
     */
    public final SdkBytes connectionFunctionCode() {
        return connectionFunctionCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(ifMatch());
        hashCode = 31 * hashCode + Objects.hashCode(connectionFunctionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(connectionFunctionCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectionFunctionRequest)) {
            return false;
        }
        UpdateConnectionFunctionRequest other = (UpdateConnectionFunctionRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(ifMatch(), other.ifMatch())
                && Objects.equals(connectionFunctionConfig(), other.connectionFunctionConfig())
                && Objects.equals(connectionFunctionCode(), other.connectionFunctionCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConnectionFunctionRequest").add("Id", id()).add("IfMatch", ifMatch())
                .add("ConnectionFunctionConfig", connectionFunctionConfig())
                .add("ConnectionFunctionCode", connectionFunctionCode() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IfMatch":
            return Optional.ofNullable(clazz.cast(ifMatch()));
        case "ConnectionFunctionConfig":
            return Optional.ofNullable(clazz.cast(connectionFunctionConfig()));
        case "ConnectionFunctionCode":
            return Optional.ofNullable(clazz.cast(connectionFunctionCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("If-Match", IF_MATCH_FIELD);
        map.put("ConnectionFunctionConfig", CONNECTION_FUNCTION_CONFIG_FIELD);
        map.put("ConnectionFunctionCode", CONNECTION_FUNCTION_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectionFunctionRequest, T> g) {
        return obj -> g.apply((UpdateConnectionFunctionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateConnectionFunctionRequest> {
        /**
         * <p>
         * The connection function ID.
         * </p>
         * 
         * @param id
         *        The connection function ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The current version (<code>ETag</code> value) of the connection function you are updating.
         * </p>
         * 
         * @param ifMatch
         *        The current version (<code>ETag</code> value) of the connection function you are updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);

        /**
         * Sets the value of the ConnectionFunctionConfig property for this object.
         *
         * @param connectionFunctionConfig
         *        The new value for the ConnectionFunctionConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionFunctionConfig(FunctionConfig connectionFunctionConfig);

        /**
         * Sets the value of the ConnectionFunctionConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FunctionConfig.Builder} avoiding the need
         * to create one manually via {@link FunctionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FunctionConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #connectionFunctionConfig(FunctionConfig)}.
         * 
         * @param connectionFunctionConfig
         *        a consumer that will call methods on {@link FunctionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionFunctionConfig(FunctionConfig)
         */
        default Builder connectionFunctionConfig(Consumer<FunctionConfig.Builder> connectionFunctionConfig) {
            return connectionFunctionConfig(FunctionConfig.builder().applyMutation(connectionFunctionConfig).build());
        }

        /**
         * <p>
         * The connection function code.
         * </p>
         * 
         * @param connectionFunctionCode
         *        The connection function code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionFunctionCode(SdkBytes connectionFunctionCode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String id;

        private String ifMatch;

        private FunctionConfig connectionFunctionConfig;

        private SdkBytes connectionFunctionCode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectionFunctionRequest model) {
            super(model);
            id(model.id);
            ifMatch(model.ifMatch);
            connectionFunctionConfig(model.connectionFunctionConfig);
            connectionFunctionCode(model.connectionFunctionCode);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final FunctionConfig.Builder getConnectionFunctionConfig() {
            return connectionFunctionConfig != null ? connectionFunctionConfig.toBuilder() : null;
        }

        public final void setConnectionFunctionConfig(FunctionConfig.BuilderImpl connectionFunctionConfig) {
            this.connectionFunctionConfig = connectionFunctionConfig != null ? connectionFunctionConfig.build() : null;
        }

        @Override
        public final Builder connectionFunctionConfig(FunctionConfig connectionFunctionConfig) {
            this.connectionFunctionConfig = connectionFunctionConfig;
            return this;
        }

        public final ByteBuffer getConnectionFunctionCode() {
            return connectionFunctionCode == null ? null : connectionFunctionCode.asByteBuffer();
        }

        public final void setConnectionFunctionCode(ByteBuffer connectionFunctionCode) {
            connectionFunctionCode(connectionFunctionCode == null ? null : SdkBytes.fromByteBuffer(connectionFunctionCode));
        }

        @Override
        public final Builder connectionFunctionCode(SdkBytes connectionFunctionCode) {
            this.connectionFunctionCode = connectionFunctionCode;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectionFunctionRequest build() {
            return new UpdateConnectionFunctionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
