/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAnycastIpListRequest extends CloudFrontRequest implements
        ToCopyableBuilder<UpdateAnycastIpListRequest.Builder, UpdateAnycastIpListRequest> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(UpdateAnycastIpListRequest::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpAddressType")
            .getter(getter(UpdateAnycastIpListRequest::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType")
                    .unmarshallLocationName("IpAddressType").build()).build();

    private static final SdkField<String> IF_MATCH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IfMatch")
            .getter(getter(UpdateAnycastIpListRequest::ifMatch))
            .setter(setter(Builder::ifMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match")
                    .unmarshallLocationName("If-Match").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            IP_ADDRESS_TYPE_FIELD, IF_MATCH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String ipAddressType;

    private final String ifMatch;

    private UpdateAnycastIpListRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.ipAddressType = builder.ipAddressType;
        this.ifMatch = builder.ifMatch;
    }

    /**
     * <p>
     * The ID of the Anycast static IP list.
     * </p>
     * 
     * @return The ID of the Anycast static IP list.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The IP address type for the Anycast static IP list. You can specify one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ipv4</code> only
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ipv6</code> only
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dualstack</code> - Allocate a list of both IPv4 and IPv6 addresses
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type for the Anycast static IP list. You can specify one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ipv4</code> only
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ipv6</code> only
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dualstack</code> - Allocate a list of both IPv4 and IPv6 addresses
     *         </p>
     *         </li>
     * @see IpAddressType
     */
    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * The IP address type for the Anycast static IP list. You can specify one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ipv4</code> only
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ipv6</code> only
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dualstack</code> - Allocate a list of both IPv4 and IPv6 addresses
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type for the Anycast static IP list. You can specify one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ipv4</code> only
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ipv6</code> only
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dualstack</code> - Allocate a list of both IPv4 and IPv6 addresses
     *         </p>
     *         </li>
     * @see IpAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    /**
     * <p>
     * The current version (ETag value) of the Anycast static IP list that you are updating.
     * </p>
     * 
     * @return The current version (ETag value) of the Anycast static IP list that you are updating.
     */
    public final String ifMatch() {
        return ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ifMatch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAnycastIpListRequest)) {
            return false;
        }
        UpdateAnycastIpListRequest other = (UpdateAnycastIpListRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString())
                && Objects.equals(ifMatch(), other.ifMatch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAnycastIpListRequest").add("Id", id()).add("IpAddressType", ipAddressTypeAsString())
                .add("IfMatch", ifMatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IpAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        case "IfMatch":
            return Optional.ofNullable(clazz.cast(ifMatch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("IpAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("If-Match", IF_MATCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAnycastIpListRequest, T> g) {
        return obj -> g.apply((UpdateAnycastIpListRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAnycastIpListRequest> {
        /**
         * <p>
         * The ID of the Anycast static IP list.
         * </p>
         * 
         * @param id
         *        The ID of the Anycast static IP list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The IP address type for the Anycast static IP list. You can specify one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ipv4</code> only
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6</code> only
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dualstack</code> - Allocate a list of both IPv4 and IPv6 addresses
         * </p>
         * </li>
         * </ul>
         * 
         * @param ipAddressType
         *        The IP address type for the Anycast static IP list. You can specify one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ipv4</code> only
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6</code> only
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dualstack</code> - Allocate a list of both IPv4 and IPv6 addresses
         *        </p>
         *        </li>
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The IP address type for the Anycast static IP list. You can specify one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ipv4</code> only
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6</code> only
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dualstack</code> - Allocate a list of both IPv4 and IPv6 addresses
         * </p>
         * </li>
         * </ul>
         * 
         * @param ipAddressType
         *        The IP address type for the Anycast static IP list. You can specify one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ipv4</code> only
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6</code> only
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dualstack</code> - Allocate a list of both IPv4 and IPv6 addresses
         *        </p>
         *        </li>
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(IpAddressType ipAddressType);

        /**
         * <p>
         * The current version (ETag value) of the Anycast static IP list that you are updating.
         * </p>
         * 
         * @param ifMatch
         *        The current version (ETag value) of the Anycast static IP list that you are updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String id;

        private String ipAddressType;

        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAnycastIpListRequest model) {
            super(model);
            id(model.id);
            ipAddressType(model.ipAddressType);
            ifMatch(model.ifMatch);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAnycastIpListRequest build() {
            return new UpdateAnycastIpListRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
