/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A trust store configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrustStoreConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<TrustStoreConfig.Builder, TrustStoreConfig> {
    private static final SdkField<String> TRUST_STORE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrustStoreId")
            .getter(getter(TrustStoreConfig::trustStoreId))
            .setter(setter(Builder::trustStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStoreId")
                    .unmarshallLocationName("TrustStoreId").build()).build();

    private static final SdkField<Boolean> ADVERTISE_TRUST_STORE_CA_NAMES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AdvertiseTrustStoreCaNames")
            .getter(getter(TrustStoreConfig::advertiseTrustStoreCaNames))
            .setter(setter(Builder::advertiseTrustStoreCaNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvertiseTrustStoreCaNames")
                    .unmarshallLocationName("AdvertiseTrustStoreCaNames").build()).build();

    private static final SdkField<Boolean> IGNORE_CERTIFICATE_EXPIRY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IgnoreCertificateExpiry")
            .getter(getter(TrustStoreConfig::ignoreCertificateExpiry))
            .setter(setter(Builder::ignoreCertificateExpiry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IgnoreCertificateExpiry")
                    .unmarshallLocationName("IgnoreCertificateExpiry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_STORE_ID_FIELD,
            ADVERTISE_TRUST_STORE_CA_NAMES_FIELD, IGNORE_CERTIFICATE_EXPIRY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String trustStoreId;

    private final Boolean advertiseTrustStoreCaNames;

    private final Boolean ignoreCertificateExpiry;

    private TrustStoreConfig(BuilderImpl builder) {
        this.trustStoreId = builder.trustStoreId;
        this.advertiseTrustStoreCaNames = builder.advertiseTrustStoreCaNames;
        this.ignoreCertificateExpiry = builder.ignoreCertificateExpiry;
    }

    /**
     * <p>
     * The trust store ID.
     * </p>
     * 
     * @return The trust store ID.
     */
    public final String trustStoreId() {
        return trustStoreId;
    }

    /**
     * <p>
     * The configuration to use to advertise trust store CA names.
     * </p>
     * 
     * @return The configuration to use to advertise trust store CA names.
     */
    public final Boolean advertiseTrustStoreCaNames() {
        return advertiseTrustStoreCaNames;
    }

    /**
     * <p>
     * The configuration to use to ignore certificate expiration.
     * </p>
     * 
     * @return The configuration to use to ignore certificate expiration.
     */
    public final Boolean ignoreCertificateExpiry() {
        return ignoreCertificateExpiry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trustStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(advertiseTrustStoreCaNames());
        hashCode = 31 * hashCode + Objects.hashCode(ignoreCertificateExpiry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustStoreConfig)) {
            return false;
        }
        TrustStoreConfig other = (TrustStoreConfig) obj;
        return Objects.equals(trustStoreId(), other.trustStoreId())
                && Objects.equals(advertiseTrustStoreCaNames(), other.advertiseTrustStoreCaNames())
                && Objects.equals(ignoreCertificateExpiry(), other.ignoreCertificateExpiry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrustStoreConfig").add("TrustStoreId", trustStoreId())
                .add("AdvertiseTrustStoreCaNames", advertiseTrustStoreCaNames())
                .add("IgnoreCertificateExpiry", ignoreCertificateExpiry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrustStoreId":
            return Optional.ofNullable(clazz.cast(trustStoreId()));
        case "AdvertiseTrustStoreCaNames":
            return Optional.ofNullable(clazz.cast(advertiseTrustStoreCaNames()));
        case "IgnoreCertificateExpiry":
            return Optional.ofNullable(clazz.cast(ignoreCertificateExpiry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrustStoreId", TRUST_STORE_ID_FIELD);
        map.put("AdvertiseTrustStoreCaNames", ADVERTISE_TRUST_STORE_CA_NAMES_FIELD);
        map.put("IgnoreCertificateExpiry", IGNORE_CERTIFICATE_EXPIRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrustStoreConfig, T> g) {
        return obj -> g.apply((TrustStoreConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrustStoreConfig> {
        /**
         * <p>
         * The trust store ID.
         * </p>
         * 
         * @param trustStoreId
         *        The trust store ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustStoreId(String trustStoreId);

        /**
         * <p>
         * The configuration to use to advertise trust store CA names.
         * </p>
         * 
         * @param advertiseTrustStoreCaNames
         *        The configuration to use to advertise trust store CA names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advertiseTrustStoreCaNames(Boolean advertiseTrustStoreCaNames);

        /**
         * <p>
         * The configuration to use to ignore certificate expiration.
         * </p>
         * 
         * @param ignoreCertificateExpiry
         *        The configuration to use to ignore certificate expiration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreCertificateExpiry(Boolean ignoreCertificateExpiry);
    }

    static final class BuilderImpl implements Builder {
        private String trustStoreId;

        private Boolean advertiseTrustStoreCaNames;

        private Boolean ignoreCertificateExpiry;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustStoreConfig model) {
            trustStoreId(model.trustStoreId);
            advertiseTrustStoreCaNames(model.advertiseTrustStoreCaNames);
            ignoreCertificateExpiry(model.ignoreCertificateExpiry);
        }

        public final String getTrustStoreId() {
            return trustStoreId;
        }

        public final void setTrustStoreId(String trustStoreId) {
            this.trustStoreId = trustStoreId;
        }

        @Override
        public final Builder trustStoreId(String trustStoreId) {
            this.trustStoreId = trustStoreId;
            return this;
        }

        public final Boolean getAdvertiseTrustStoreCaNames() {
            return advertiseTrustStoreCaNames;
        }

        public final void setAdvertiseTrustStoreCaNames(Boolean advertiseTrustStoreCaNames) {
            this.advertiseTrustStoreCaNames = advertiseTrustStoreCaNames;
        }

        @Override
        public final Builder advertiseTrustStoreCaNames(Boolean advertiseTrustStoreCaNames) {
            this.advertiseTrustStoreCaNames = advertiseTrustStoreCaNames;
            return this;
        }

        public final Boolean getIgnoreCertificateExpiry() {
            return ignoreCertificateExpiry;
        }

        public final void setIgnoreCertificateExpiry(Boolean ignoreCertificateExpiry) {
            this.ignoreCertificateExpiry = ignoreCertificateExpiry;
        }

        @Override
        public final Builder ignoreCertificateExpiry(Boolean ignoreCertificateExpiry) {
            this.ignoreCertificateExpiry = ignoreCertificateExpiry;
            return this;
        }

        @Override
        public TrustStoreConfig build() {
            return new TrustStoreConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
