/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A trust store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrustStore implements SdkPojo, Serializable, ToCopyableBuilder<TrustStore.Builder, TrustStore> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(TrustStore::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Arn")
            .getter(getter(TrustStore::arn))
            .setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").unmarshallLocationName("Arn")
                    .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(TrustStore::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(TrustStore::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("Status").build()).build();

    private static final SdkField<Integer> NUMBER_OF_CA_CERTIFICATES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfCaCertificates")
            .getter(getter(TrustStore::numberOfCaCertificates))
            .setter(setter(Builder::numberOfCaCertificates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfCaCertificates")
                    .unmarshallLocationName("NumberOfCaCertificates").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime")
            .getter(getter(TrustStore::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime")
                    .unmarshallLocationName("LastModifiedTime").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Reason")
            .getter(getter(TrustStore::reason))
            .setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason")
                    .unmarshallLocationName("Reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, STATUS_FIELD, NUMBER_OF_CA_CERTIFICATES_FIELD, LAST_MODIFIED_TIME_FIELD, REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String name;

    private final String status;

    private final Integer numberOfCaCertificates;

    private final Instant lastModifiedTime;

    private final String reason;

    private TrustStore(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.status = builder.status;
        this.numberOfCaCertificates = builder.numberOfCaCertificates;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The trust store's ID.
     * </p>
     * 
     * @return The trust store's ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The trust store's Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The trust store's Amazon Resource Name (ARN).
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The trust store's name.
     * </p>
     * 
     * @return The trust store's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The trust store's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TrustStoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The trust store's status.
     * @see TrustStoreStatus
     */
    public final TrustStoreStatus status() {
        return TrustStoreStatus.fromValue(status);
    }

    /**
     * <p>
     * The trust store's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TrustStoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The trust store's status.
     * @see TrustStoreStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The trust store's number of CA certificates.
     * </p>
     * 
     * @return The trust store's number of CA certificates.
     */
    public final Integer numberOfCaCertificates() {
        return numberOfCaCertificates;
    }

    /**
     * <p>
     * The trust store's last modified time.
     * </p>
     * 
     * @return The trust store's last modified time.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The trust store's reason.
     * </p>
     * 
     * @return The trust store's reason.
     */
    public final String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfCaCertificates());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustStore)) {
            return false;
        }
        TrustStore other = (TrustStore) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(numberOfCaCertificates(), other.numberOfCaCertificates())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(reason(), other.reason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrustStore").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("Status", statusAsString()).add("NumberOfCaCertificates", numberOfCaCertificates())
                .add("LastModifiedTime", lastModifiedTime()).add("Reason", reason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "NumberOfCaCertificates":
            return Optional.ofNullable(clazz.cast(numberOfCaCertificates()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("NumberOfCaCertificates", NUMBER_OF_CA_CERTIFICATES_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("Reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrustStore, T> g) {
        return obj -> g.apply((TrustStore) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrustStore> {
        /**
         * <p>
         * The trust store's ID.
         * </p>
         * 
         * @param id
         *        The trust store's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The trust store's Amazon Resource Name (ARN).
         * </p>
         * 
         * @param arn
         *        The trust store's Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The trust store's name.
         * </p>
         * 
         * @param name
         *        The trust store's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The trust store's status.
         * </p>
         * 
         * @param status
         *        The trust store's status.
         * @see TrustStoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustStoreStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The trust store's status.
         * </p>
         * 
         * @param status
         *        The trust store's status.
         * @see TrustStoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustStoreStatus
         */
        Builder status(TrustStoreStatus status);

        /**
         * <p>
         * The trust store's number of CA certificates.
         * </p>
         * 
         * @param numberOfCaCertificates
         *        The trust store's number of CA certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfCaCertificates(Integer numberOfCaCertificates);

        /**
         * <p>
         * The trust store's last modified time.
         * </p>
         * 
         * @param lastModifiedTime
         *        The trust store's last modified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The trust store's reason.
         * </p>
         * 
         * @param reason
         *        The trust store's reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String status;

        private Integer numberOfCaCertificates;

        private Instant lastModifiedTime;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustStore model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            status(model.status);
            numberOfCaCertificates(model.numberOfCaCertificates);
            lastModifiedTime(model.lastModifiedTime);
            reason(model.reason);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TrustStoreStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getNumberOfCaCertificates() {
            return numberOfCaCertificates;
        }

        public final void setNumberOfCaCertificates(Integer numberOfCaCertificates) {
            this.numberOfCaCertificates = numberOfCaCertificates;
        }

        @Override
        public final Builder numberOfCaCertificates(Integer numberOfCaCertificates) {
            this.numberOfCaCertificates = numberOfCaCertificates;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public TrustStore build() {
            return new TrustStore(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
