/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDistributionsByConnectionModeRequest extends CloudFrontRequest implements
        ToCopyableBuilder<ListDistributionsByConnectionModeRequest.Builder, ListDistributionsByConnectionModeRequest> {
    private static final SdkField<String> MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Marker")
            .getter(getter(ListDistributionsByConnectionModeRequest::marker))
            .setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker")
                    .unmarshallLocationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems")
            .getter(getter(ListDistributionsByConnectionModeRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final SdkField<String> CONNECTION_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConnectionMode")
            .getter(getter(ListDistributionsByConnectionModeRequest::connectionModeAsString))
            .setter(setter(Builder::connectionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConnectionMode")
                    .unmarshallLocationName("ConnectionMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, MAX_ITEMS_FIELD,
            CONNECTION_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String marker;

    private final Integer maxItems;

    private final String connectionMode;

    private ListDistributionsByConnectionModeRequest(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
        this.connectionMode = builder.connectionMode;
    }

    /**
     * <p>
     * The marker for the next set of distributions to retrieve.
     * </p>
     * 
     * @return The marker for the next set of distributions to retrieve.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of distributions to return.
     * </p>
     * 
     * @return The maximum number of distributions to return.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * This field specifies whether the connection mode is through a standard distribution (direct) or a multi-tenant
     * distribution with distribution tenants (tenant-only).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionMode}
     * will return {@link ConnectionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionModeAsString}.
     * </p>
     * 
     * @return This field specifies whether the connection mode is through a standard distribution (direct) or a
     *         multi-tenant distribution with distribution tenants (tenant-only).
     * @see ConnectionMode
     */
    public final ConnectionMode connectionMode() {
        return ConnectionMode.fromValue(connectionMode);
    }

    /**
     * <p>
     * This field specifies whether the connection mode is through a standard distribution (direct) or a multi-tenant
     * distribution with distribution tenants (tenant-only).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionMode}
     * will return {@link ConnectionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionModeAsString}.
     * </p>
     * 
     * @return This field specifies whether the connection mode is through a standard distribution (direct) or a
     *         multi-tenant distribution with distribution tenants (tenant-only).
     * @see ConnectionMode
     */
    public final String connectionModeAsString() {
        return connectionMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(connectionModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDistributionsByConnectionModeRequest)) {
            return false;
        }
        ListDistributionsByConnectionModeRequest other = (ListDistributionsByConnectionModeRequest) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(maxItems(), other.maxItems())
                && Objects.equals(connectionModeAsString(), other.connectionModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDistributionsByConnectionModeRequest").add("Marker", marker()).add("MaxItems", maxItems())
                .add("ConnectionMode", connectionModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "ConnectionMode":
            return Optional.ofNullable(clazz.cast(connectionModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Marker", MARKER_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        map.put("ConnectionMode", CONNECTION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDistributionsByConnectionModeRequest, T> g) {
        return obj -> g.apply((ListDistributionsByConnectionModeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDistributionsByConnectionModeRequest> {
        /**
         * <p>
         * The marker for the next set of distributions to retrieve.
         * </p>
         * 
         * @param marker
         *        The marker for the next set of distributions to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of distributions to return.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of distributions to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * This field specifies whether the connection mode is through a standard distribution (direct) or a
         * multi-tenant distribution with distribution tenants (tenant-only).
         * </p>
         * 
         * @param connectionMode
         *        This field specifies whether the connection mode is through a standard distribution (direct) or a
         *        multi-tenant distribution with distribution tenants (tenant-only).
         * @see ConnectionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionMode
         */
        Builder connectionMode(String connectionMode);

        /**
         * <p>
         * This field specifies whether the connection mode is through a standard distribution (direct) or a
         * multi-tenant distribution with distribution tenants (tenant-only).
         * </p>
         * 
         * @param connectionMode
         *        This field specifies whether the connection mode is through a standard distribution (direct) or a
         *        multi-tenant distribution with distribution tenants (tenant-only).
         * @see ConnectionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionMode
         */
        Builder connectionMode(ConnectionMode connectionMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String marker;

        private Integer maxItems;

        private String connectionMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDistributionsByConnectionModeRequest model) {
            super(model);
            marker(model.marker);
            maxItems(model.maxItems);
            connectionMode(model.connectionMode);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getConnectionMode() {
            return connectionMode;
        }

        public final void setConnectionMode(String connectionMode) {
            this.connectionMode = connectionMode;
        }

        @Override
        public final Builder connectionMode(String connectionMode) {
            this.connectionMode = connectionMode;
            return this;
        }

        @Override
        public final Builder connectionMode(ConnectionMode connectionMode) {
            this.connectionMode(connectionMode == null ? null : connectionMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDistributionsByConnectionModeRequest build() {
            return new ListDistributionsByConnectionModeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
