/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConnectionFunctionsRequest extends CloudFrontRequest implements
        ToCopyableBuilder<ListConnectionFunctionsRequest.Builder, ListConnectionFunctionsRequest> {
    private static final SdkField<String> MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Marker")
            .getter(getter(ListConnectionFunctionsRequest::marker))
            .setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker")
                    .unmarshallLocationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems")
            .getter(getter(ListConnectionFunctionsRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final SdkField<String> STAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Stage")
            .getter(getter(ListConnectionFunctionsRequest::stageAsString))
            .setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stage")
                    .unmarshallLocationName("Stage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, MAX_ITEMS_FIELD,
            STAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String marker;

    private final Integer maxItems;

    private final String stage;

    private ListConnectionFunctionsRequest(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
        this.stage = builder.stage;
    }

    /**
     * <p>
     * Use this field when paginating results to indicate where to begin in your list. The response includes items in
     * the list that occur after the marker. To get the next page of the list, set this field's value to the value of
     * <code>NextMarker</code> from the current page's response.
     * </p>
     * 
     * @return Use this field when paginating results to indicate where to begin in your list. The response includes
     *         items in the list that occur after the marker. To get the next page of the list, set this field's value
     *         to the value of <code>NextMarker</code> from the current page's response.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of connection functions that you want returned in the response.
     * </p>
     * 
     * @return The maximum number of connection functions that you want returned in the response.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * The connection function's stage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link FunctionStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return The connection function's stage.
     * @see FunctionStage
     */
    public final FunctionStage stage() {
        return FunctionStage.fromValue(stage);
    }

    /**
     * <p>
     * The connection function's stage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link FunctionStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return The connection function's stage.
     * @see FunctionStage
     */
    public final String stageAsString() {
        return stage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(stageAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectionFunctionsRequest)) {
            return false;
        }
        ListConnectionFunctionsRequest other = (ListConnectionFunctionsRequest) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(maxItems(), other.maxItems())
                && Objects.equals(stageAsString(), other.stageAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConnectionFunctionsRequest").add("Marker", marker()).add("MaxItems", maxItems())
                .add("Stage", stageAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "Stage":
            return Optional.ofNullable(clazz.cast(stageAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Marker", MARKER_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        map.put("Stage", STAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConnectionFunctionsRequest, T> g) {
        return obj -> g.apply((ListConnectionFunctionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListConnectionFunctionsRequest> {
        /**
         * <p>
         * Use this field when paginating results to indicate where to begin in your list. The response includes items
         * in the list that occur after the marker. To get the next page of the list, set this field's value to the
         * value of <code>NextMarker</code> from the current page's response.
         * </p>
         * 
         * @param marker
         *        Use this field when paginating results to indicate where to begin in your list. The response includes
         *        items in the list that occur after the marker. To get the next page of the list, set this field's
         *        value to the value of <code>NextMarker</code> from the current page's response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of connection functions that you want returned in the response.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of connection functions that you want returned in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * The connection function's stage.
         * </p>
         * 
         * @param stage
         *        The connection function's stage.
         * @see FunctionStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FunctionStage
         */
        Builder stage(String stage);

        /**
         * <p>
         * The connection function's stage.
         * </p>
         * 
         * @param stage
         *        The connection function's stage.
         * @see FunctionStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FunctionStage
         */
        Builder stage(FunctionStage stage);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String marker;

        private Integer maxItems;

        private String stage;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConnectionFunctionsRequest model) {
            super(model);
            marker(model.marker);
            maxItems(model.maxItems);
            stage(model.stage);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getStage() {
            return stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public final Builder stage(FunctionStage stage) {
            this.stage(stage == null ? null : stage.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListConnectionFunctionsRequest build() {
            return new ListConnectionFunctionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
