/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTrustStoreResponse extends CloudFrontResponse implements
        ToCopyableBuilder<GetTrustStoreResponse.Builder, GetTrustStoreResponse> {
    private static final SdkField<TrustStore> TRUST_STORE_FIELD = SdkField
            .<TrustStore> builder(MarshallingType.SDK_POJO)
            .memberName("TrustStore")
            .getter(getter(GetTrustStoreResponse::trustStore))
            .setter(setter(Builder::trustStore))
            .constructor(TrustStore::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStore")
                    .unmarshallLocationName("TrustStore").build(), PayloadTrait.create()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ETag")
            .getter(getter(GetTrustStoreResponse::eTag))
            .setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRUST_STORE_FIELD, E_TAG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TrustStore trustStore;

    private final String eTag;

    private GetTrustStoreResponse(BuilderImpl builder) {
        super(builder);
        this.trustStore = builder.trustStore;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The trust store.
     * </p>
     * 
     * @return The trust store.
     */
    public final TrustStore trustStore() {
        return trustStore;
    }

    /**
     * <p>
     * The version identifier for the current version of the trust store.
     * </p>
     * 
     * @return The version identifier for the current version of the trust store.
     */
    public final String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trustStore());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTrustStoreResponse)) {
            return false;
        }
        GetTrustStoreResponse other = (GetTrustStoreResponse) obj;
        return Objects.equals(trustStore(), other.trustStore()) && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTrustStoreResponse").add("TrustStore", trustStore()).add("ETag", eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrustStore":
            return Optional.ofNullable(clazz.cast(trustStore()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrustStore", TRUST_STORE_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTrustStoreResponse, T> g) {
        return obj -> g.apply((GetTrustStoreResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTrustStoreResponse> {
        /**
         * <p>
         * The trust store.
         * </p>
         * 
         * @param trustStore
         *        The trust store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustStore(TrustStore trustStore);

        /**
         * <p>
         * The trust store.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrustStore.Builder} avoiding the need to
         * create one manually via {@link TrustStore#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrustStore.Builder#build()} is called immediately and its result
         * is passed to {@link #trustStore(TrustStore)}.
         * 
         * @param trustStore
         *        a consumer that will call methods on {@link TrustStore.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trustStore(TrustStore)
         */
        default Builder trustStore(Consumer<TrustStore.Builder> trustStore) {
            return trustStore(TrustStore.builder().applyMutation(trustStore).build());
        }

        /**
         * <p>
         * The version identifier for the current version of the trust store.
         * </p>
         * 
         * @param eTag
         *        The version identifier for the current version of the trust store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private TrustStore trustStore;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTrustStoreResponse model) {
            super(model);
            trustStore(model.trustStore);
            eTag(model.eTag);
        }

        public final TrustStore.Builder getTrustStore() {
            return trustStore != null ? trustStore.toBuilder() : null;
        }

        public final void setTrustStore(TrustStore.BuilderImpl trustStore) {
            this.trustStore = trustStore != null ? trustStore.build() : null;
        }

        @Override
        public final Builder trustStore(TrustStore trustStore) {
            this.trustStore = trustStore;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public GetTrustStoreResponse build() {
            return new GetTrustStoreResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
