/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The DNS configuration for your domain names.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DnsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DnsConfiguration.Builder, DnsConfiguration> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Domain")
            .getter(getter(DnsConfiguration::domain))
            .setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain")
                    .unmarshallLocationName("Domain").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(DnsConfiguration::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("Status").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Reason")
            .getter(getter(DnsConfiguration::reason))
            .setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason")
                    .unmarshallLocationName("Reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, STATUS_FIELD,
            REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domain;

    private final String status;

    private final String reason;

    private DnsConfiguration(BuilderImpl builder) {
        this.domain = builder.domain;
        this.status = builder.status;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The domain name that you're verifying.
     * </p>
     * 
     * @return The domain name that you're verifying.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The status of your domain name.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>valid-configuration</code>: The domain name is correctly configured and points to the correct routing
     * endpoint of the connection group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>invalid-configuration</code>: There is either a missing DNS record or the DNS record exists but it's using
     * an incorrect routing endpoint. Update the DNS record to point to the correct routing endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unknown-configuration</code>: CloudFront can't validate your DNS configuration. This status can appear if
     * CloudFront can't verify the DNS record, or the DNS lookup request failed or timed out.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DnsConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of your domain name.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>valid-configuration</code>: The domain name is correctly configured and points to the correct
     *         routing endpoint of the connection group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>invalid-configuration</code>: There is either a missing DNS record or the DNS record exists but
     *         it's using an incorrect routing endpoint. Update the DNS record to point to the correct routing endpoint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unknown-configuration</code>: CloudFront can't validate your DNS configuration. This status can
     *         appear if CloudFront can't verify the DNS record, or the DNS lookup request failed or timed out.
     *         </p>
     *         </li>
     * @see DnsConfigurationStatus
     */
    public final DnsConfigurationStatus status() {
        return DnsConfigurationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of your domain name.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>valid-configuration</code>: The domain name is correctly configured and points to the correct routing
     * endpoint of the connection group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>invalid-configuration</code>: There is either a missing DNS record or the DNS record exists but it's using
     * an incorrect routing endpoint. Update the DNS record to point to the correct routing endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unknown-configuration</code>: CloudFront can't validate your DNS configuration. This status can appear if
     * CloudFront can't verify the DNS record, or the DNS lookup request failed or timed out.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DnsConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of your domain name.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>valid-configuration</code>: The domain name is correctly configured and points to the correct
     *         routing endpoint of the connection group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>invalid-configuration</code>: There is either a missing DNS record or the DNS record exists but
     *         it's using an incorrect routing endpoint. Update the DNS record to point to the correct routing endpoint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unknown-configuration</code>: CloudFront can't validate your DNS configuration. This status can
     *         appear if CloudFront can't verify the DNS record, or the DNS lookup request failed or timed out.
     *         </p>
     *         </li>
     * @see DnsConfigurationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Explains the status of the DNS configuration.
     * </p>
     * 
     * @return Explains the status of the DNS configuration.
     */
    public final String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsConfiguration)) {
            return false;
        }
        DnsConfiguration other = (DnsConfiguration) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(reason(), other.reason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DnsConfiguration").add("Domain", domain()).add("Status", statusAsString())
                .add("Reason", reason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Domain", DOMAIN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DnsConfiguration, T> g) {
        return obj -> g.apply((DnsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DnsConfiguration> {
        /**
         * <p>
         * The domain name that you're verifying.
         * </p>
         * 
         * @param domain
         *        The domain name that you're verifying.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The status of your domain name.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>valid-configuration</code>: The domain name is correctly configured and points to the correct routing
         * endpoint of the connection group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>invalid-configuration</code>: There is either a missing DNS record or the DNS record exists but it's
         * using an incorrect routing endpoint. Update the DNS record to point to the correct routing endpoint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unknown-configuration</code>: CloudFront can't validate your DNS configuration. This status can appear
         * if CloudFront can't verify the DNS record, or the DNS lookup request failed or timed out.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of your domain name.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>valid-configuration</code>: The domain name is correctly configured and points to the correct
         *        routing endpoint of the connection group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>invalid-configuration</code>: There is either a missing DNS record or the DNS record exists but
         *        it's using an incorrect routing endpoint. Update the DNS record to point to the correct routing
         *        endpoint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unknown-configuration</code>: CloudFront can't validate your DNS configuration. This status can
         *        appear if CloudFront can't verify the DNS record, or the DNS lookup request failed or timed out.
         *        </p>
         *        </li>
         * @see DnsConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsConfigurationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of your domain name.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>valid-configuration</code>: The domain name is correctly configured and points to the correct routing
         * endpoint of the connection group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>invalid-configuration</code>: There is either a missing DNS record or the DNS record exists but it's
         * using an incorrect routing endpoint. Update the DNS record to point to the correct routing endpoint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unknown-configuration</code>: CloudFront can't validate your DNS configuration. This status can appear
         * if CloudFront can't verify the DNS record, or the DNS lookup request failed or timed out.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of your domain name.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>valid-configuration</code>: The domain name is correctly configured and points to the correct
         *        routing endpoint of the connection group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>invalid-configuration</code>: There is either a missing DNS record or the DNS record exists but
         *        it's using an incorrect routing endpoint. Update the DNS record to point to the correct routing
         *        endpoint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unknown-configuration</code>: CloudFront can't validate your DNS configuration. This status can
         *        appear if CloudFront can't verify the DNS record, or the DNS lookup request failed or timed out.
         *        </p>
         *        </li>
         * @see DnsConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsConfigurationStatus
         */
        Builder status(DnsConfigurationStatus status);

        /**
         * <p>
         * Explains the status of the DNS configuration.
         * </p>
         * 
         * @param reason
         *        Explains the status of the DNS configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);
    }

    static final class BuilderImpl implements Builder {
        private String domain;

        private String status;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsConfiguration model) {
            domain(model.domain);
            status(model.status);
            reason(model.reason);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DnsConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public DnsConfiguration build() {
            return new DnsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
